<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_resPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Samp Eau Res');
            $this->SetMenuLabel('Tbl Samp Eau Res');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_res"');
            $this->dataset->addFields(
                array(
                    new IntegerField('res_id', true, true, true),
                    new IntegerField('ana_id', true),
                    new IntegerField('elem_id'),
                    new StringField('res_ori'),
                    new IntegerField('res_stnd'),
                    new IntegerField('res_prec'),
                    new IntegerField('res_rep'),
                    new IntegerField('res_lim'),
                    new StringField('res_notes'),
                    new IntegerField('res_code')
                )
            );
            $this->dataset->AddLookupField('ana_id', '"data".tbl_samp_eau_ana', new IntegerField('ana_id'), new IntegerField('samp_id', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('elem_id', 'librairies.lib_samp_elem', new IntegerField('elem_id'), new StringField('elem_abb', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('res_code', 'librairies.lib_samp_acode', new IntegerField('lib_samp_acode_id'), new StringField('key_lib_samp_acode', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'res_id', 'res_id', 'Res Id'),
                new FilterColumn($this->dataset, 'ana_id', 'LA1', 'Ana Id'),
                new FilterColumn($this->dataset, 'elem_id', 'LA2', 'Elem Id'),
                new FilterColumn($this->dataset, 'res_ori', 'res_ori', 'Res Ori'),
                new FilterColumn($this->dataset, 'res_stnd', 'res_stnd', 'Res Stnd'),
                new FilterColumn($this->dataset, 'res_prec', 'res_prec', 'Res Prec'),
                new FilterColumn($this->dataset, 'res_rep', 'res_rep', 'Res Rep'),
                new FilterColumn($this->dataset, 'res_lim', 'res_lim', 'Res Lim'),
                new FilterColumn($this->dataset, 'res_notes', 'res_notes', 'Res Notes'),
                new FilterColumn($this->dataset, 'res_code', 'LA3', 'Res Code')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['res_id'])
                ->addColumn($columns['ana_id'])
                ->addColumn($columns['elem_id'])
                ->addColumn($columns['res_ori'])
                ->addColumn($columns['res_stnd'])
                ->addColumn($columns['res_prec'])
                ->addColumn($columns['res_rep'])
                ->addColumn($columns['res_lim'])
                ->addColumn($columns['res_notes'])
                ->addColumn($columns['res_code']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('ana_id')
                ->setOptionsFor('elem_id')
                ->setOptionsFor('res_code');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('res_id_edit');
            
            $filterBuilder->addColumn(
                $columns['res_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('ana_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('ana_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search');
            
            $filterBuilder->addColumn(
                $columns['ana_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('elem_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('elem_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search');
            
            $text_editor = new TextEdit('elem_id');
            
            $filterBuilder->addColumn(
                $columns['elem_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('res_ori_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['res_ori'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('res_stnd_edit');
            
            $filterBuilder->addColumn(
                $columns['res_stnd'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('res_prec_edit');
            
            $filterBuilder->addColumn(
                $columns['res_prec'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('res_rep_edit');
            
            $filterBuilder->addColumn(
                $columns['res_rep'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('res_lim_edit');
            
            $filterBuilder->addColumn(
                $columns['res_lim'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('res_notes');
            
            $filterBuilder->addColumn(
                $columns['res_notes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('res_code_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('res_code', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search');
            
            $text_editor = new TextEdit('res_code');
            
            $filterBuilder->addColumn(
                $columns['res_code'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for res_id field
            //
            $column = new NumberViewColumn('res_id', 'res_id', 'Res Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé primaire');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('ana_id', 'LA1', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé secondaire provenant de la table tbl_samp_trait elle est intégrée dans la bd');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for elem_abb field
            //
            $column = new TextViewColumn('elem_id', 'LA2', 'Elem Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé secondaire provenant de la table tbl_samp_elem');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for res_ori field
            //
            $column = new TextViewColumn('res_ori', 'res_ori', 'Res Ori', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('méthode utilisée');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for res_stnd field
            //
            $column = new NumberViewColumn('res_stnd', 'res_stnd', 'Res Stnd', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('résultat standardisé');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for res_prec field
            //
            $column = new NumberViewColumn('res_prec', 'res_prec', 'Res Prec', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('précision de l\'analyse  (+/-)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for res_rep field
            //
            $column = new NumberViewColumn('res_rep', 'res_rep', 'Res Rep', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('nombre de répétitions');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for res_lim field
            //
            $column = new NumberViewColumn('res_lim', 'res_lim', 'Res Lim', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Limite de détection si variable');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('notes');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for key_lib_samp_acode field
            //
            $column = new TextViewColumn('res_code', 'LA3', 'Res Code', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('code analyse lib_samp_acode');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for res_id field
            //
            $column = new NumberViewColumn('res_id', 'res_id', 'Res Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('ana_id', 'LA1', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for elem_abb field
            //
            $column = new TextViewColumn('elem_id', 'LA2', 'Elem Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for res_ori field
            //
            $column = new TextViewColumn('res_ori', 'res_ori', 'Res Ori', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for res_stnd field
            //
            $column = new NumberViewColumn('res_stnd', 'res_stnd', 'Res Stnd', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for res_prec field
            //
            $column = new NumberViewColumn('res_prec', 'res_prec', 'Res Prec', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for res_rep field
            //
            $column = new NumberViewColumn('res_rep', 'res_rep', 'Res Rep', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for res_lim field
            //
            $column = new NumberViewColumn('res_lim', 'res_lim', 'Res Lim', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for key_lib_samp_acode field
            //
            $column = new TextViewColumn('res_code', 'LA3', 'Res Code', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for ana_id field
            //
            $editor = new DynamicCombobox('ana_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $lookupDataset->setOrderByField('samp_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Id', 'ana_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search', $editor, $this->dataset, $lookupDataset, 'ana_id', 'samp_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for elem_id field
            //
            $editor = new DynamicCombobox('elem_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_elem"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('elem_id', true, true, true),
                    new StringField('elem_abb'),
                    new StringField('elem_unit'),
                    new StringField('elem_meth'),
                    new StringField('elem_name'),
                    new StringField('elem_name_f'),
                    new StringField('elem_nick_name'),
                    new IntegerField('elem_code_nelac'),
                    new StringField('elem_code_cas'),
                    new StringField('elem_cat'),
                    new StringField('elem_profil'),
                    new StringField('elem_prof_desc'),
                    new StringField('elem_profil_use'),
                    new StringField('elem_meth_desc'),
                    new StringField('elem_meth_for'),
                    new StringField('elem_meth_ref'),
                    new StringField('elem_meth_ref_url'),
                    new StringField('elem_meth_proc'),
                    new StringField('elem_up_ld'),
                    new StringField('elem_low_ld'),
                    new StringField('elem_lab_lib')
                )
            );
            $lookupDataset->setOrderByField('elem_abb', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Elem Id', 'elem_id', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search', $editor, $this->dataset, $lookupDataset, 'elem_id', 'elem_abb', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for res_ori field
            //
            $editor = new TextEdit('res_ori_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Res Ori', 'res_ori', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for res_stnd field
            //
            $editor = new TextEdit('res_stnd_edit');
            $editColumn = new CustomEditColumn('Res Stnd', 'res_stnd', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for res_prec field
            //
            $editor = new TextEdit('res_prec_edit');
            $editColumn = new CustomEditColumn('Res Prec', 'res_prec', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for res_rep field
            //
            $editor = new TextEdit('res_rep_edit');
            $editColumn = new CustomEditColumn('Res Rep', 'res_rep', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for res_lim field
            //
            $editor = new TextEdit('res_lim_edit');
            $editColumn = new CustomEditColumn('Res Lim', 'res_lim', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for res_notes field
            //
            $editor = new TextAreaEdit('res_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Res Notes', 'res_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for res_code field
            //
            $editor = new DynamicCombobox('res_code_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_acode"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_lib_samp_acode'),
                    new StringField('acode_nam'),
                    new StringField('acode_sml'),
                    new StringField('k_desc_f'),
                    new IntegerField('acode_mul'),
                    new IntegerField('acode_add'),
                    new IntegerField('lib_samp_acode_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('key_lib_samp_acode', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Res Code', 'res_code', 'LA3', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search', $editor, $this->dataset, $lookupDataset, 'lib_samp_acode_id', 'key_lib_samp_acode', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for ana_id field
            //
            $editor = new DynamicCombobox('ana_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $lookupDataset->setOrderByField('samp_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Id', 'ana_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search', $editor, $this->dataset, $lookupDataset, 'ana_id', 'samp_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for elem_id field
            //
            $editor = new DynamicCombobox('elem_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_elem"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('elem_id', true, true, true),
                    new StringField('elem_abb'),
                    new StringField('elem_unit'),
                    new StringField('elem_meth'),
                    new StringField('elem_name'),
                    new StringField('elem_name_f'),
                    new StringField('elem_nick_name'),
                    new IntegerField('elem_code_nelac'),
                    new StringField('elem_code_cas'),
                    new StringField('elem_cat'),
                    new StringField('elem_profil'),
                    new StringField('elem_prof_desc'),
                    new StringField('elem_profil_use'),
                    new StringField('elem_meth_desc'),
                    new StringField('elem_meth_for'),
                    new StringField('elem_meth_ref'),
                    new StringField('elem_meth_ref_url'),
                    new StringField('elem_meth_proc'),
                    new StringField('elem_up_ld'),
                    new StringField('elem_low_ld'),
                    new StringField('elem_lab_lib')
                )
            );
            $lookupDataset->setOrderByField('elem_abb', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Elem Id', 'elem_id', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search', $editor, $this->dataset, $lookupDataset, 'elem_id', 'elem_abb', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for res_ori field
            //
            $editor = new TextEdit('res_ori_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Res Ori', 'res_ori', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for res_stnd field
            //
            $editor = new TextEdit('res_stnd_edit');
            $editColumn = new CustomEditColumn('Res Stnd', 'res_stnd', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for res_prec field
            //
            $editor = new TextEdit('res_prec_edit');
            $editColumn = new CustomEditColumn('Res Prec', 'res_prec', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for res_rep field
            //
            $editor = new TextEdit('res_rep_edit');
            $editColumn = new CustomEditColumn('Res Rep', 'res_rep', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for res_lim field
            //
            $editor = new TextEdit('res_lim_edit');
            $editColumn = new CustomEditColumn('Res Lim', 'res_lim', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for res_notes field
            //
            $editor = new TextAreaEdit('res_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Res Notes', 'res_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for res_code field
            //
            $editor = new DynamicCombobox('res_code_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_acode"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_lib_samp_acode'),
                    new StringField('acode_nam'),
                    new StringField('acode_sml'),
                    new StringField('k_desc_f'),
                    new IntegerField('acode_mul'),
                    new IntegerField('acode_add'),
                    new IntegerField('lib_samp_acode_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('key_lib_samp_acode', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Res Code', 'res_code', 'LA3', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search', $editor, $this->dataset, $lookupDataset, 'lib_samp_acode_id', 'key_lib_samp_acode', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for ana_id field
            //
            $editor = new DynamicCombobox('ana_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $lookupDataset->setOrderByField('samp_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Id', 'ana_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search', $editor, $this->dataset, $lookupDataset, 'ana_id', 'samp_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for elem_id field
            //
            $editor = new DynamicCombobox('elem_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_elem"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('elem_id', true, true, true),
                    new StringField('elem_abb'),
                    new StringField('elem_unit'),
                    new StringField('elem_meth'),
                    new StringField('elem_name'),
                    new StringField('elem_name_f'),
                    new StringField('elem_nick_name'),
                    new IntegerField('elem_code_nelac'),
                    new StringField('elem_code_cas'),
                    new StringField('elem_cat'),
                    new StringField('elem_profil'),
                    new StringField('elem_prof_desc'),
                    new StringField('elem_profil_use'),
                    new StringField('elem_meth_desc'),
                    new StringField('elem_meth_for'),
                    new StringField('elem_meth_ref'),
                    new StringField('elem_meth_ref_url'),
                    new StringField('elem_meth_proc'),
                    new StringField('elem_up_ld'),
                    new StringField('elem_low_ld'),
                    new StringField('elem_lab_lib')
                )
            );
            $lookupDataset->setOrderByField('elem_abb', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Elem Id', 'elem_id', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search', $editor, $this->dataset, $lookupDataset, 'elem_id', 'elem_abb', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for res_ori field
            //
            $editor = new TextEdit('res_ori_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Res Ori', 'res_ori', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for res_stnd field
            //
            $editor = new TextEdit('res_stnd_edit');
            $editColumn = new CustomEditColumn('Res Stnd', 'res_stnd', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for res_prec field
            //
            $editor = new TextEdit('res_prec_edit');
            $editColumn = new CustomEditColumn('Res Prec', 'res_prec', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for res_rep field
            //
            $editor = new TextEdit('res_rep_edit');
            $editColumn = new CustomEditColumn('Res Rep', 'res_rep', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for res_lim field
            //
            $editor = new TextEdit('res_lim_edit');
            $editColumn = new CustomEditColumn('Res Lim', 'res_lim', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for res_notes field
            //
            $editor = new TextAreaEdit('res_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Res Notes', 'res_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for res_code field
            //
            $editor = new DynamicCombobox('res_code_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_acode"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_lib_samp_acode'),
                    new StringField('acode_nam'),
                    new StringField('acode_sml'),
                    new StringField('k_desc_f'),
                    new IntegerField('acode_mul'),
                    new IntegerField('acode_add'),
                    new IntegerField('lib_samp_acode_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('key_lib_samp_acode', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Res Code', 'res_code', 'LA3', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search', $editor, $this->dataset, $lookupDataset, 'lib_samp_acode_id', 'key_lib_samp_acode', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for res_id field
            //
            $column = new NumberViewColumn('res_id', 'res_id', 'Res Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('ana_id', 'LA1', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for elem_abb field
            //
            $column = new TextViewColumn('elem_id', 'LA2', 'Elem Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for res_ori field
            //
            $column = new TextViewColumn('res_ori', 'res_ori', 'Res Ori', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for res_stnd field
            //
            $column = new NumberViewColumn('res_stnd', 'res_stnd', 'Res Stnd', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for res_prec field
            //
            $column = new NumberViewColumn('res_prec', 'res_prec', 'Res Prec', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for res_rep field
            //
            $column = new NumberViewColumn('res_rep', 'res_rep', 'Res Rep', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for res_lim field
            //
            $column = new NumberViewColumn('res_lim', 'res_lim', 'Res Lim', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for key_lib_samp_acode field
            //
            $column = new TextViewColumn('res_code', 'LA3', 'Res Code', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for res_id field
            //
            $column = new NumberViewColumn('res_id', 'res_id', 'Res Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('ana_id', 'LA1', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for elem_abb field
            //
            $column = new TextViewColumn('elem_id', 'LA2', 'Elem Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for res_ori field
            //
            $column = new TextViewColumn('res_ori', 'res_ori', 'Res Ori', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for res_stnd field
            //
            $column = new NumberViewColumn('res_stnd', 'res_stnd', 'Res Stnd', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for res_prec field
            //
            $column = new NumberViewColumn('res_prec', 'res_prec', 'Res Prec', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for res_rep field
            //
            $column = new NumberViewColumn('res_rep', 'res_rep', 'Res Rep', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for res_lim field
            //
            $column = new NumberViewColumn('res_lim', 'res_lim', 'Res Lim', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for key_lib_samp_acode field
            //
            $column = new TextViewColumn('res_code', 'LA3', 'Res Code', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('ana_id', 'LA1', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for elem_abb field
            //
            $column = new TextViewColumn('elem_id', 'LA2', 'Elem Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for res_ori field
            //
            $column = new TextViewColumn('res_ori', 'res_ori', 'Res Ori', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for res_stnd field
            //
            $column = new NumberViewColumn('res_stnd', 'res_stnd', 'Res Stnd', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for res_prec field
            //
            $column = new NumberViewColumn('res_prec', 'res_prec', 'Res Prec', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for res_rep field
            //
            $column = new NumberViewColumn('res_rep', 'res_rep', 'Res Rep', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for res_lim field
            //
            $column = new NumberViewColumn('res_lim', 'res_lim', 'Res Lim', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for key_lib_samp_acode field
            //
            $column = new TextViewColumn('res_code', 'LA3', 'Res Code', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $lookupDataset->setOrderByField('samp_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search', 'ana_id', 'samp_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_elem"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('elem_id', true, true, true),
                    new StringField('elem_abb'),
                    new StringField('elem_unit'),
                    new StringField('elem_meth'),
                    new StringField('elem_name'),
                    new StringField('elem_name_f'),
                    new StringField('elem_nick_name'),
                    new IntegerField('elem_code_nelac'),
                    new StringField('elem_code_cas'),
                    new StringField('elem_cat'),
                    new StringField('elem_profil'),
                    new StringField('elem_prof_desc'),
                    new StringField('elem_profil_use'),
                    new StringField('elem_meth_desc'),
                    new StringField('elem_meth_for'),
                    new StringField('elem_meth_ref'),
                    new StringField('elem_meth_ref_url'),
                    new StringField('elem_meth_proc'),
                    new StringField('elem_up_ld'),
                    new StringField('elem_low_ld'),
                    new StringField('elem_lab_lib')
                )
            );
            $lookupDataset->setOrderByField('elem_abb', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search', 'elem_id', 'elem_abb', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_acode"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_lib_samp_acode'),
                    new StringField('acode_nam'),
                    new StringField('acode_sml'),
                    new StringField('k_desc_f'),
                    new IntegerField('acode_mul'),
                    new IntegerField('acode_add'),
                    new IntegerField('lib_samp_acode_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('key_lib_samp_acode', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search', 'lib_samp_acode_id', 'key_lib_samp_acode', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $lookupDataset->setOrderByField('samp_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search', 'ana_id', 'samp_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_elem"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('elem_id', true, true, true),
                    new StringField('elem_abb'),
                    new StringField('elem_unit'),
                    new StringField('elem_meth'),
                    new StringField('elem_name'),
                    new StringField('elem_name_f'),
                    new StringField('elem_nick_name'),
                    new IntegerField('elem_code_nelac'),
                    new StringField('elem_code_cas'),
                    new StringField('elem_cat'),
                    new StringField('elem_profil'),
                    new StringField('elem_prof_desc'),
                    new StringField('elem_profil_use'),
                    new StringField('elem_meth_desc'),
                    new StringField('elem_meth_for'),
                    new StringField('elem_meth_ref'),
                    new StringField('elem_meth_ref_url'),
                    new StringField('elem_meth_proc'),
                    new StringField('elem_up_ld'),
                    new StringField('elem_low_ld'),
                    new StringField('elem_lab_lib')
                )
            );
            $lookupDataset->setOrderByField('elem_abb', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search', 'elem_id', 'elem_abb', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_acode"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_lib_samp_acode'),
                    new StringField('acode_nam'),
                    new StringField('acode_sml'),
                    new StringField('k_desc_f'),
                    new IntegerField('acode_mul'),
                    new IntegerField('acode_add'),
                    new IntegerField('lib_samp_acode_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('key_lib_samp_acode', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search', 'lib_samp_acode_id', 'key_lib_samp_acode', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for res_notes field
            //
            $column = new TextViewColumn('res_notes', 'res_notes', 'Res Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $lookupDataset->setOrderByField('samp_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search', 'ana_id', 'samp_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_elem"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('elem_id', true, true, true),
                    new StringField('elem_abb'),
                    new StringField('elem_unit'),
                    new StringField('elem_meth'),
                    new StringField('elem_name'),
                    new StringField('elem_name_f'),
                    new StringField('elem_nick_name'),
                    new IntegerField('elem_code_nelac'),
                    new StringField('elem_code_cas'),
                    new StringField('elem_cat'),
                    new StringField('elem_profil'),
                    new StringField('elem_prof_desc'),
                    new StringField('elem_profil_use'),
                    new StringField('elem_meth_desc'),
                    new StringField('elem_meth_for'),
                    new StringField('elem_meth_ref'),
                    new StringField('elem_meth_ref_url'),
                    new StringField('elem_meth_proc'),
                    new StringField('elem_up_ld'),
                    new StringField('elem_low_ld'),
                    new StringField('elem_lab_lib')
                )
            );
            $lookupDataset->setOrderByField('elem_abb', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search', 'elem_id', 'elem_abb', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_acode"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_lib_samp_acode'),
                    new StringField('acode_nam'),
                    new StringField('acode_sml'),
                    new StringField('k_desc_f'),
                    new IntegerField('acode_mul'),
                    new IntegerField('acode_add'),
                    new IntegerField('lib_samp_acode_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('key_lib_samp_acode', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search', 'lib_samp_acode_id', 'key_lib_samp_acode', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $lookupDataset->setOrderByField('samp_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_ana_id_search', 'ana_id', 'samp_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_elem"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('elem_id', true, true, true),
                    new StringField('elem_abb'),
                    new StringField('elem_unit'),
                    new StringField('elem_meth'),
                    new StringField('elem_name'),
                    new StringField('elem_name_f'),
                    new StringField('elem_nick_name'),
                    new IntegerField('elem_code_nelac'),
                    new StringField('elem_code_cas'),
                    new StringField('elem_cat'),
                    new StringField('elem_profil'),
                    new StringField('elem_prof_desc'),
                    new StringField('elem_profil_use'),
                    new StringField('elem_meth_desc'),
                    new StringField('elem_meth_for'),
                    new StringField('elem_meth_ref'),
                    new StringField('elem_meth_ref_url'),
                    new StringField('elem_meth_proc'),
                    new StringField('elem_up_ld'),
                    new StringField('elem_low_ld'),
                    new StringField('elem_lab_lib')
                )
            );
            $lookupDataset->setOrderByField('elem_abb', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_elem_id_search', 'elem_id', 'elem_abb', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_acode"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_lib_samp_acode'),
                    new StringField('acode_nam'),
                    new StringField('acode_sml'),
                    new StringField('k_desc_f'),
                    new IntegerField('acode_mul'),
                    new IntegerField('acode_add'),
                    new IntegerField('lib_samp_acode_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('key_lib_samp_acode', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_res_code_search', 'lib_samp_acode_id', 'key_lib_samp_acode', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_anaPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Samp Eau Ana');
            $this->SetMenuLabel('Tbl Samp Eau Ana');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau_ana"');
            $this->dataset->addFields(
                array(
                    new IntegerField('ana_id', true, true, true),
                    new IntegerField('samp_id'),
                    new StringField('ana_samp_name'),
                    new IntegerField('ana_type_lib'),
                    new StringField('ana_samp_type_sub'),
                    new StringField('ana_type_lib_text'),
                    new IntegerField('ana_lab_lib'),
                    new IntegerField('ana_bout_nb'),
                    new IntegerField('ana_bout_capa'),
                    new StringField('ana_bour_fil_meto'),
                    new StringField('ana_bour_fil_nutri'),
                    new StringField('ana_bour_fil_anion'),
                    new StringField('ana_bout_entr_lib'),
                    new StringField('ana_bout_agent_lib'),
                    new IntegerField('ana_bout_agent_conc'),
                    new StringField('ana_bout_agent_uni'),
                    new StringField('notes')
                )
            );
            $this->dataset->AddLookupField('samp_id', '"data".tbl_samp_eau', new IntegerField('samp_id'), new StringField('samp_name', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('ana_type_lib', 'librairies.lib_samp_ana_type', new IntegerField('ana_id'), new StringField('ana_desc', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('ana_lab_lib', 'librairies.lib_samp_lab', new IntegerField('lab_id'), new StringField('organisme', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'ana_id', 'ana_id', 'Ana Id'),
                new FilterColumn($this->dataset, 'samp_id', 'LA1', 'Samp Id'),
                new FilterColumn($this->dataset, 'ana_samp_name', 'ana_samp_name', 'Ana Samp Name'),
                new FilterColumn($this->dataset, 'ana_type_lib', 'LA2', 'Ana Type Lib'),
                new FilterColumn($this->dataset, 'ana_samp_type_sub', 'ana_samp_type_sub', 'Ana Samp Type Sub'),
                new FilterColumn($this->dataset, 'ana_type_lib_text', 'ana_type_lib_text', 'Ana Type Lib Text'),
                new FilterColumn($this->dataset, 'ana_lab_lib', 'LA3', 'Ana Lab Lib'),
                new FilterColumn($this->dataset, 'ana_bout_nb', 'ana_bout_nb', 'Ana Bout Nb'),
                new FilterColumn($this->dataset, 'ana_bout_capa', 'ana_bout_capa', 'Ana Bout Capa'),
                new FilterColumn($this->dataset, 'ana_bour_fil_meto', 'ana_bour_fil_meto', 'Ana Bour Fil Meto'),
                new FilterColumn($this->dataset, 'ana_bour_fil_nutri', 'ana_bour_fil_nutri', 'Ana Bour Fil Nutri'),
                new FilterColumn($this->dataset, 'ana_bour_fil_anion', 'ana_bour_fil_anion', 'Ana Bour Fil Anion'),
                new FilterColumn($this->dataset, 'ana_bout_entr_lib', 'ana_bout_entr_lib', 'Ana Bout Entr Lib'),
                new FilterColumn($this->dataset, 'ana_bout_agent_lib', 'ana_bout_agent_lib', 'Ana Bout Agent Lib'),
                new FilterColumn($this->dataset, 'ana_bout_agent_conc', 'ana_bout_agent_conc', 'Ana Bout Agent Conc'),
                new FilterColumn($this->dataset, 'ana_bout_agent_uni', 'ana_bout_agent_uni', 'Ana Bout Agent Uni'),
                new FilterColumn($this->dataset, 'notes', 'notes', 'Notes')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['ana_id'])
                ->addColumn($columns['samp_id'])
                ->addColumn($columns['ana_samp_name'])
                ->addColumn($columns['ana_type_lib'])
                ->addColumn($columns['ana_lab_lib'])
                ->addColumn($columns['ana_bout_nb'])
                ->addColumn($columns['ana_bout_capa'])
                ->addColumn($columns['ana_bour_fil_meto'])
                ->addColumn($columns['ana_bour_fil_nutri'])
                ->addColumn($columns['ana_bour_fil_anion'])
                ->addColumn($columns['ana_bout_entr_lib'])
                ->addColumn($columns['ana_bout_agent_lib'])
                ->addColumn($columns['ana_bout_agent_conc'])
                ->addColumn($columns['ana_bout_agent_uni'])
                ->addColumn($columns['notes']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('samp_id')
                ->setOptionsFor('ana_type_lib')
                ->setOptionsFor('ana_lab_lib');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('ana_id_edit');
            
            $filterBuilder->addColumn(
                $columns['ana_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('samp_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('samp_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search');
            
            $text_editor = new TextEdit('samp_id');
            
            $filterBuilder->addColumn(
                $columns['samp_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_samp_name_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['ana_samp_name'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('ana_type_lib_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('ana_type_lib', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search');
            
            $text_editor = new TextEdit('ana_type_lib');
            
            $filterBuilder->addColumn(
                $columns['ana_type_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('ana_lab_lib_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('ana_lab_lib', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search');
            
            $text_editor = new TextEdit('ana_lab_lib');
            
            $filterBuilder->addColumn(
                $columns['ana_lab_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bout_nb_edit');
            
            $filterBuilder->addColumn(
                $columns['ana_bout_nb'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bout_capa_edit');
            
            $filterBuilder->addColumn(
                $columns['ana_bout_capa'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bour_fil_meto_edit');
            $main_editor->SetMaxLength(3);
            
            $filterBuilder->addColumn(
                $columns['ana_bour_fil_meto'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bour_fil_nutri_edit');
            $main_editor->SetMaxLength(3);
            
            $filterBuilder->addColumn(
                $columns['ana_bour_fil_nutri'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bour_fil_anion_edit');
            $main_editor->SetMaxLength(3);
            
            $filterBuilder->addColumn(
                $columns['ana_bour_fil_anion'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bout_entr_lib_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['ana_bout_entr_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bout_agent_lib_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['ana_bout_agent_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bout_agent_conc_edit');
            
            $filterBuilder->addColumn(
                $columns['ana_bout_agent_conc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ana_bout_agent_uni_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['ana_bout_agent_uni'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('notes');
            
            $filterBuilder->addColumn(
                $columns['notes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana.data.tbl_samp_eau_res')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res detail
            //
            $column = new DetailColumn(array('ana_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana.data.tbl_samp_eau_res', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_handler', $this->dataset, 'Tbl Samp Eau Res');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for ana_id field
            //
            $column = new NumberViewColumn('ana_id', 'ana_id', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('(P) Identifiant unique analyses prévues');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_id', 'LA1', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('(F) tl_samp_eau');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_samp_name field
            //
            $column = new TextViewColumn('ana_samp_name', 'ana_samp_name', 'Ana Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('nom de l\'échantillon ou duplicata analysé');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('type d\'analyse (lib_samp_ana_type)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for organisme field
            //
            $column = new TextViewColumn('ana_lab_lib', 'LA3', 'Ana Lab Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('laboratoire qui a effectué l\'analyse (lib_samp_lab)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bout_nb field
            //
            $column = new NumberViewColumn('ana_bout_nb', 'ana_bout_nb', 'Ana Bout Nb', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('nombre de bouteilles');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bout_capa field
            //
            $column = new NumberViewColumn('ana_bout_capa', 'ana_bout_capa', 'Ana Bout Capa', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('capacité (mL)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bour_fil_meto field
            //
            $column = new TextViewColumn('ana_bour_fil_meto', 'ana_bour_fil_meto', 'Ana Bour Fil Meto', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('est-elle filtrée? métaux');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bour_fil_nutri field
            //
            $column = new TextViewColumn('ana_bour_fil_nutri', 'ana_bour_fil_nutri', 'Ana Bour Fil Nutri', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('est-elle filtrée? nutrimen');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bour_fil_anion field
            //
            $column = new TextViewColumn('ana_bour_fil_anion', 'ana_bour_fil_anion', 'Ana Bour Fil Anion', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('est-elle filtrée? anion');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bout_entr_lib field
            //
            $column = new TextViewColumn('ana_bout_entr_lib', 'ana_bout_entr_lib', 'Ana Bout Entr Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('méthode d\'entreposage (réfrigération, congélation, air ambiant)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bout_agent_lib field
            //
            $column = new TextViewColumn('ana_bout_agent_lib', 'ana_bout_agent_lib', 'Ana Bout Agent Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('agent ajouté il y a une librairie !!!');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bout_agent_conc field
            //
            $column = new NumberViewColumn('ana_bout_agent_conc', 'ana_bout_agent_conc', 'Ana Bout Agent Conc', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('agent concentration');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ana_bout_agent_uni field
            //
            $column = new TextViewColumn('ana_bout_agent_uni', 'ana_bout_agent_uni', 'Ana Bout Agent Uni', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('agent concentration unité de mesure');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for ana_id field
            //
            $column = new NumberViewColumn('ana_id', 'ana_id', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_id', 'LA1', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_samp_name field
            //
            $column = new TextViewColumn('ana_samp_name', 'ana_samp_name', 'Ana Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for organisme field
            //
            $column = new TextViewColumn('ana_lab_lib', 'LA3', 'Ana Lab Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bout_nb field
            //
            $column = new NumberViewColumn('ana_bout_nb', 'ana_bout_nb', 'Ana Bout Nb', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bout_capa field
            //
            $column = new NumberViewColumn('ana_bout_capa', 'ana_bout_capa', 'Ana Bout Capa', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bour_fil_meto field
            //
            $column = new TextViewColumn('ana_bour_fil_meto', 'ana_bour_fil_meto', 'Ana Bour Fil Meto', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bour_fil_nutri field
            //
            $column = new TextViewColumn('ana_bour_fil_nutri', 'ana_bour_fil_nutri', 'Ana Bour Fil Nutri', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bour_fil_anion field
            //
            $column = new TextViewColumn('ana_bour_fil_anion', 'ana_bour_fil_anion', 'Ana Bour Fil Anion', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bout_entr_lib field
            //
            $column = new TextViewColumn('ana_bout_entr_lib', 'ana_bout_entr_lib', 'Ana Bout Entr Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bout_agent_lib field
            //
            $column = new TextViewColumn('ana_bout_agent_lib', 'ana_bout_agent_lib', 'Ana Bout Agent Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bout_agent_conc field
            //
            $column = new NumberViewColumn('ana_bout_agent_conc', 'ana_bout_agent_conc', 'Ana Bout Agent Conc', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ana_bout_agent_uni field
            //
            $column = new TextViewColumn('ana_bout_agent_uni', 'ana_bout_agent_uni', 'Ana Bout Agent Uni', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for samp_id field
            //
            $editor = new DynamicCombobox('samp_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $lookupDataset->setOrderByField('samp_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Samp Id', 'samp_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search', $editor, $this->dataset, $lookupDataset, 'samp_id', 'samp_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_samp_name field
            //
            $editor = new TextEdit('ana_samp_name_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Samp Name', 'ana_samp_name', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_type_lib field
            //
            $editor = new DynamicCombobox('ana_type_lib_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_ana_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true),
                    new StringField('ana_desc')
                )
            );
            $lookupDataset->setOrderByField('ana_desc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Type Lib', 'ana_type_lib', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search', $editor, $this->dataset, $lookupDataset, 'ana_id', 'ana_desc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_lab_lib field
            //
            $editor = new DynamicCombobox('ana_lab_lib_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_lab"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lab_id', true, true),
                    new StringField('la_key'),
                    new StringField('k_desc'),
                    new StringField('organisme'),
                    new StringField('division'),
                    new StringField('adresse'),
                    new StringField('ville'),
                    new StringField('province'),
                    new StringField('pays'),
                    new StringField('code_postal'),
                    new StringField('telephone'),
                    new StringField('telecopieur'),
                    new StringField('contact'),
                    new StringField('contact_titre')
                )
            );
            $lookupDataset->setOrderByField('organisme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Lab Lib', 'ana_lab_lib', 'LA3', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search', $editor, $this->dataset, $lookupDataset, 'lab_id', 'organisme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_nb field
            //
            $editor = new TextEdit('ana_bout_nb_edit');
            $editColumn = new CustomEditColumn('Ana Bout Nb', 'ana_bout_nb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_capa field
            //
            $editor = new TextEdit('ana_bout_capa_edit');
            $editColumn = new CustomEditColumn('Ana Bout Capa', 'ana_bout_capa', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_meto field
            //
            $editor = new TextEdit('ana_bour_fil_meto_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Meto', 'ana_bour_fil_meto', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_nutri field
            //
            $editor = new TextEdit('ana_bour_fil_nutri_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Nutri', 'ana_bour_fil_nutri', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_anion field
            //
            $editor = new TextEdit('ana_bour_fil_anion_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Anion', 'ana_bour_fil_anion', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_entr_lib field
            //
            $editor = new TextEdit('ana_bout_entr_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Entr Lib', 'ana_bout_entr_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_lib field
            //
            $editor = new TextEdit('ana_bout_agent_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Agent Lib', 'ana_bout_agent_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_conc field
            //
            $editor = new TextEdit('ana_bout_agent_conc_edit');
            $editColumn = new CustomEditColumn('Ana Bout Agent Conc', 'ana_bout_agent_conc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_uni field
            //
            $editor = new TextEdit('ana_bout_agent_uni_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Agent Uni', 'ana_bout_agent_uni', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for samp_id field
            //
            $editor = new DynamicCombobox('samp_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $lookupDataset->setOrderByField('samp_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Samp Id', 'samp_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search', $editor, $this->dataset, $lookupDataset, 'samp_id', 'samp_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_samp_name field
            //
            $editor = new TextEdit('ana_samp_name_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Samp Name', 'ana_samp_name', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_type_lib field
            //
            $editor = new DynamicCombobox('ana_type_lib_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_ana_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true),
                    new StringField('ana_desc')
                )
            );
            $lookupDataset->setOrderByField('ana_desc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Type Lib', 'ana_type_lib', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search', $editor, $this->dataset, $lookupDataset, 'ana_id', 'ana_desc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_lab_lib field
            //
            $editor = new DynamicCombobox('ana_lab_lib_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_lab"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lab_id', true, true),
                    new StringField('la_key'),
                    new StringField('k_desc'),
                    new StringField('organisme'),
                    new StringField('division'),
                    new StringField('adresse'),
                    new StringField('ville'),
                    new StringField('province'),
                    new StringField('pays'),
                    new StringField('code_postal'),
                    new StringField('telephone'),
                    new StringField('telecopieur'),
                    new StringField('contact'),
                    new StringField('contact_titre')
                )
            );
            $lookupDataset->setOrderByField('organisme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Lab Lib', 'ana_lab_lib', 'LA3', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search', $editor, $this->dataset, $lookupDataset, 'lab_id', 'organisme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_nb field
            //
            $editor = new TextEdit('ana_bout_nb_edit');
            $editColumn = new CustomEditColumn('Ana Bout Nb', 'ana_bout_nb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_capa field
            //
            $editor = new TextEdit('ana_bout_capa_edit');
            $editColumn = new CustomEditColumn('Ana Bout Capa', 'ana_bout_capa', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_meto field
            //
            $editor = new TextEdit('ana_bour_fil_meto_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Meto', 'ana_bour_fil_meto', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_nutri field
            //
            $editor = new TextEdit('ana_bour_fil_nutri_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Nutri', 'ana_bour_fil_nutri', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_anion field
            //
            $editor = new TextEdit('ana_bour_fil_anion_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Anion', 'ana_bour_fil_anion', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_entr_lib field
            //
            $editor = new TextEdit('ana_bout_entr_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Entr Lib', 'ana_bout_entr_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_lib field
            //
            $editor = new TextEdit('ana_bout_agent_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Agent Lib', 'ana_bout_agent_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_conc field
            //
            $editor = new TextEdit('ana_bout_agent_conc_edit');
            $editColumn = new CustomEditColumn('Ana Bout Agent Conc', 'ana_bout_agent_conc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_uni field
            //
            $editor = new TextEdit('ana_bout_agent_uni_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Agent Uni', 'ana_bout_agent_uni', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for samp_id field
            //
            $editor = new DynamicCombobox('samp_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $lookupDataset->setOrderByField('samp_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Samp Id', 'samp_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search', $editor, $this->dataset, $lookupDataset, 'samp_id', 'samp_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_samp_name field
            //
            $editor = new TextEdit('ana_samp_name_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Samp Name', 'ana_samp_name', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_type_lib field
            //
            $editor = new DynamicCombobox('ana_type_lib_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_ana_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true),
                    new StringField('ana_desc')
                )
            );
            $lookupDataset->setOrderByField('ana_desc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Type Lib', 'ana_type_lib', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search', $editor, $this->dataset, $lookupDataset, 'ana_id', 'ana_desc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_lab_lib field
            //
            $editor = new DynamicCombobox('ana_lab_lib_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_lab"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lab_id', true, true),
                    new StringField('la_key'),
                    new StringField('k_desc'),
                    new StringField('organisme'),
                    new StringField('division'),
                    new StringField('adresse'),
                    new StringField('ville'),
                    new StringField('province'),
                    new StringField('pays'),
                    new StringField('code_postal'),
                    new StringField('telephone'),
                    new StringField('telecopieur'),
                    new StringField('contact'),
                    new StringField('contact_titre')
                )
            );
            $lookupDataset->setOrderByField('organisme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Ana Lab Lib', 'ana_lab_lib', 'LA3', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search', $editor, $this->dataset, $lookupDataset, 'lab_id', 'organisme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bout_nb field
            //
            $editor = new TextEdit('ana_bout_nb_edit');
            $editColumn = new CustomEditColumn('Ana Bout Nb', 'ana_bout_nb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bout_capa field
            //
            $editor = new TextEdit('ana_bout_capa_edit');
            $editColumn = new CustomEditColumn('Ana Bout Capa', 'ana_bout_capa', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_meto field
            //
            $editor = new TextEdit('ana_bour_fil_meto_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Meto', 'ana_bour_fil_meto', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_nutri field
            //
            $editor = new TextEdit('ana_bour_fil_nutri_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Nutri', 'ana_bour_fil_nutri', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bour_fil_anion field
            //
            $editor = new TextEdit('ana_bour_fil_anion_edit');
            $editor->SetMaxLength(3);
            $editColumn = new CustomEditColumn('Ana Bour Fil Anion', 'ana_bour_fil_anion', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bout_entr_lib field
            //
            $editor = new TextEdit('ana_bout_entr_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Entr Lib', 'ana_bout_entr_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_lib field
            //
            $editor = new TextEdit('ana_bout_agent_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Agent Lib', 'ana_bout_agent_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_conc field
            //
            $editor = new TextEdit('ana_bout_agent_conc_edit');
            $editColumn = new CustomEditColumn('Ana Bout Agent Conc', 'ana_bout_agent_conc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ana_bout_agent_uni field
            //
            $editor = new TextEdit('ana_bout_agent_uni_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Ana Bout Agent Uni', 'ana_bout_agent_uni', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for ana_id field
            //
            $column = new NumberViewColumn('ana_id', 'ana_id', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_id', 'LA1', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_samp_name field
            //
            $column = new TextViewColumn('ana_samp_name', 'ana_samp_name', 'Ana Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for organisme field
            //
            $column = new TextViewColumn('ana_lab_lib', 'LA3', 'Ana Lab Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bout_nb field
            //
            $column = new NumberViewColumn('ana_bout_nb', 'ana_bout_nb', 'Ana Bout Nb', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bout_capa field
            //
            $column = new NumberViewColumn('ana_bout_capa', 'ana_bout_capa', 'Ana Bout Capa', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bour_fil_meto field
            //
            $column = new TextViewColumn('ana_bour_fil_meto', 'ana_bour_fil_meto', 'Ana Bour Fil Meto', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bour_fil_nutri field
            //
            $column = new TextViewColumn('ana_bour_fil_nutri', 'ana_bour_fil_nutri', 'Ana Bour Fil Nutri', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bour_fil_anion field
            //
            $column = new TextViewColumn('ana_bour_fil_anion', 'ana_bour_fil_anion', 'Ana Bour Fil Anion', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bout_entr_lib field
            //
            $column = new TextViewColumn('ana_bout_entr_lib', 'ana_bout_entr_lib', 'Ana Bout Entr Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bout_agent_lib field
            //
            $column = new TextViewColumn('ana_bout_agent_lib', 'ana_bout_agent_lib', 'Ana Bout Agent Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bout_agent_conc field
            //
            $column = new NumberViewColumn('ana_bout_agent_conc', 'ana_bout_agent_conc', 'Ana Bout Agent Conc', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ana_bout_agent_uni field
            //
            $column = new TextViewColumn('ana_bout_agent_uni', 'ana_bout_agent_uni', 'Ana Bout Agent Uni', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_print');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for ana_id field
            //
            $column = new NumberViewColumn('ana_id', 'ana_id', 'Ana Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_id', 'LA1', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_samp_name field
            //
            $column = new TextViewColumn('ana_samp_name', 'ana_samp_name', 'Ana Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for organisme field
            //
            $column = new TextViewColumn('ana_lab_lib', 'LA3', 'Ana Lab Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bout_nb field
            //
            $column = new NumberViewColumn('ana_bout_nb', 'ana_bout_nb', 'Ana Bout Nb', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bout_capa field
            //
            $column = new NumberViewColumn('ana_bout_capa', 'ana_bout_capa', 'Ana Bout Capa', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bour_fil_meto field
            //
            $column = new TextViewColumn('ana_bour_fil_meto', 'ana_bour_fil_meto', 'Ana Bour Fil Meto', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bour_fil_nutri field
            //
            $column = new TextViewColumn('ana_bour_fil_nutri', 'ana_bour_fil_nutri', 'Ana Bour Fil Nutri', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bour_fil_anion field
            //
            $column = new TextViewColumn('ana_bour_fil_anion', 'ana_bour_fil_anion', 'Ana Bour Fil Anion', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bout_entr_lib field
            //
            $column = new TextViewColumn('ana_bout_entr_lib', 'ana_bout_entr_lib', 'Ana Bout Entr Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bout_agent_lib field
            //
            $column = new TextViewColumn('ana_bout_agent_lib', 'ana_bout_agent_lib', 'Ana Bout Agent Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bout_agent_conc field
            //
            $column = new NumberViewColumn('ana_bout_agent_conc', 'ana_bout_agent_conc', 'Ana Bout Agent Conc', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for ana_bout_agent_uni field
            //
            $column = new TextViewColumn('ana_bout_agent_uni', 'ana_bout_agent_uni', 'Ana Bout Agent Uni', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_export');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_id', 'LA1', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_samp_name field
            //
            $column = new TextViewColumn('ana_samp_name', 'ana_samp_name', 'Ana Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for organisme field
            //
            $column = new TextViewColumn('ana_lab_lib', 'LA3', 'Ana Lab Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bout_nb field
            //
            $column = new NumberViewColumn('ana_bout_nb', 'ana_bout_nb', 'Ana Bout Nb', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bout_capa field
            //
            $column = new NumberViewColumn('ana_bout_capa', 'ana_bout_capa', 'Ana Bout Capa', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bour_fil_meto field
            //
            $column = new TextViewColumn('ana_bour_fil_meto', 'ana_bour_fil_meto', 'Ana Bour Fil Meto', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bour_fil_nutri field
            //
            $column = new TextViewColumn('ana_bour_fil_nutri', 'ana_bour_fil_nutri', 'Ana Bour Fil Nutri', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bour_fil_anion field
            //
            $column = new TextViewColumn('ana_bour_fil_anion', 'ana_bour_fil_anion', 'Ana Bour Fil Anion', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bout_entr_lib field
            //
            $column = new TextViewColumn('ana_bout_entr_lib', 'ana_bout_entr_lib', 'Ana Bout Entr Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bout_agent_lib field
            //
            $column = new TextViewColumn('ana_bout_agent_lib', 'ana_bout_agent_lib', 'Ana Bout Agent Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bout_agent_conc field
            //
            $column = new NumberViewColumn('ana_bout_agent_conc', 'ana_bout_agent_conc', 'Ana Bout Agent Conc', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for ana_bout_agent_uni field
            //
            $column = new TextViewColumn('ana_bout_agent_uni', 'ana_bout_agent_uni', 'Ana Bout Agent Uni', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_compare');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function CreateMasterDetailRecordGrid()
        {
            $result = new Grid($this, $this->dataset);
            
            $this->AddFieldColumns($result, false);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            
            $result->SetAllowDeleteSelected(false);
            $result->SetShowUpdateLink(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $this->setupGridColumnGroup($result);
            $this->attachGridEventHandlers($result);
            
            return $result;
        }
        
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $detailPage = new data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_resPage('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res', $this, array('ana_id'), array('ana_id'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana.data.tbl_samp_eau_res'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana.data.tbl_samp_eau_res'));
            $detailPage->SetHttpHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_handler');
            $handler = new PageHTTPHandler('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_data_tbl_samp_eau_res_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $lookupDataset->setOrderByField('samp_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search', 'samp_id', 'samp_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_ana_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true),
                    new StringField('ana_desc')
                )
            );
            $lookupDataset->setOrderByField('ana_desc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search', 'ana_id', 'ana_desc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_lab"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lab_id', true, true),
                    new StringField('la_key'),
                    new StringField('k_desc'),
                    new StringField('organisme'),
                    new StringField('division'),
                    new StringField('adresse'),
                    new StringField('ville'),
                    new StringField('province'),
                    new StringField('pays'),
                    new StringField('code_postal'),
                    new StringField('telephone'),
                    new StringField('telecopieur'),
                    new StringField('contact'),
                    new StringField('contact_titre')
                )
            );
            $lookupDataset->setOrderByField('organisme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search', 'lab_id', 'organisme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $lookupDataset->setOrderByField('samp_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search', 'samp_id', 'samp_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_ana_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true),
                    new StringField('ana_desc')
                )
            );
            $lookupDataset->setOrderByField('ana_desc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search', 'ana_id', 'ana_desc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_lab"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lab_id', true, true),
                    new StringField('la_key'),
                    new StringField('k_desc'),
                    new StringField('organisme'),
                    new StringField('division'),
                    new StringField('adresse'),
                    new StringField('ville'),
                    new StringField('province'),
                    new StringField('pays'),
                    new StringField('code_postal'),
                    new StringField('telephone'),
                    new StringField('telecopieur'),
                    new StringField('contact'),
                    new StringField('contact_titre')
                )
            );
            $lookupDataset->setOrderByField('organisme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search', 'lab_id', 'organisme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for ana_desc field
            //
            $column = new TextViewColumn('ana_type_lib', 'LA2', 'Ana Type Lib', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_LA2_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $lookupDataset->setOrderByField('samp_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search', 'samp_id', 'samp_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_ana_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true),
                    new StringField('ana_desc')
                )
            );
            $lookupDataset->setOrderByField('ana_desc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search', 'ana_id', 'ana_desc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_lab"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lab_id', true, true),
                    new StringField('la_key'),
                    new StringField('k_desc'),
                    new StringField('organisme'),
                    new StringField('division'),
                    new StringField('adresse'),
                    new StringField('ville'),
                    new StringField('province'),
                    new StringField('pays'),
                    new StringField('code_postal'),
                    new StringField('telephone'),
                    new StringField('telecopieur'),
                    new StringField('contact'),
                    new StringField('contact_titre')
                )
            );
            $lookupDataset->setOrderByField('organisme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search', 'lab_id', 'organisme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $lookupDataset->setOrderByField('samp_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_samp_id_search', 'samp_id', 'samp_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_ana_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ana_id', true, true),
                    new StringField('ana_desc')
                )
            );
            $lookupDataset->setOrderByField('ana_desc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_type_lib_search', 'ana_id', 'ana_desc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_lab"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lab_id', true, true),
                    new StringField('la_key'),
                    new StringField('k_desc'),
                    new StringField('organisme'),
                    new StringField('division'),
                    new StringField('adresse'),
                    new StringField('ville'),
                    new StringField('province'),
                    new StringField('pays'),
                    new StringField('code_postal'),
                    new StringField('telephone'),
                    new StringField('telecopieur'),
                    new StringField('contact'),
                    new StringField('contact_titre')
                )
            );
            $lookupDataset->setOrderByField('organisme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_ana_lab_lib_search', 'lab_id', 'organisme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eauPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Samp Eau');
            $this->SetMenuLabel('Tbl Samp Eau');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_samp_eau"');
            $this->dataset->addFields(
                array(
                    new IntegerField('samp_id', true, true, true),
                    new StringField('samp_name'),
                    new StringField('samp_name_dup'),
                    new StringField('samp_name_blk'),
                    new StringField('samp_blk_prov'),
                    new StringField('se_heure'),
                    new StringField('se_type', true),
                    new StringField('se_prove', true),
                    new StringField('se_meth'),
                    new IntegerField('interv_id'),
                    new IntegerField('se_prof_from'),
                    new IntegerField('se_prof_to'),
                    new IntegerField('se_purge_vol'),
                    new StringField('se_purge_duree'),
                    new IntegerField('se_purge_debit'),
                    new StringField('se_purge_meth'),
                    new StringField('se_notes'),
                    new IntegerField('samp_obs_name_id'),
                    new StringField('samp_observ_numb')
                )
            );
            $this->dataset->AddLookupField('se_type', 'librairies.lib_samp_eau_type', new StringField('key_lib_samp_eau_type'), new StringField('k_desc_f', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('se_prove', 'librairies.lib_puits_captage', new StringField('key_lib_puits_captage'), new StringField('k_desc_f', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('interv_id', '"data".tbl_puits_interv', new IntegerField('interv_id'), new StringField('obs_name', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('samp_obs_name_id', '"data".tbl_observation', new IntegerField('observation_id'), new StringField('obs_name', false, false, false, false, 'LA4', 'LT4'), 'LT4');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'samp_id', 'samp_id', 'Samp Id'),
                new FilterColumn($this->dataset, 'samp_name', 'samp_name', 'Samp Name'),
                new FilterColumn($this->dataset, 'samp_name_dup', 'samp_name_dup', 'Samp Name Dup'),
                new FilterColumn($this->dataset, 'samp_name_blk', 'samp_name_blk', 'Samp Name Blk'),
                new FilterColumn($this->dataset, 'samp_blk_prov', 'samp_blk_prov', 'Samp Blk Prov'),
                new FilterColumn($this->dataset, 'se_heure', 'se_heure', 'Se Heure'),
                new FilterColumn($this->dataset, 'se_type', 'LA1', 'Se Type'),
                new FilterColumn($this->dataset, 'se_prove', 'LA2', 'Se Prove'),
                new FilterColumn($this->dataset, 'se_meth', 'se_meth', 'Se Meth'),
                new FilterColumn($this->dataset, 'interv_id', 'LA3', 'Interv Id'),
                new FilterColumn($this->dataset, 'se_prof_from', 'se_prof_from', 'Se Prof From'),
                new FilterColumn($this->dataset, 'se_prof_to', 'se_prof_to', 'Se Prof To'),
                new FilterColumn($this->dataset, 'se_purge_vol', 'se_purge_vol', 'Se Purge Vol'),
                new FilterColumn($this->dataset, 'se_purge_duree', 'se_purge_duree', 'Se Purge Duree'),
                new FilterColumn($this->dataset, 'se_purge_debit', 'se_purge_debit', 'Se Purge Debit'),
                new FilterColumn($this->dataset, 'se_purge_meth', 'se_purge_meth', 'Se Purge Meth'),
                new FilterColumn($this->dataset, 'se_notes', 'se_notes', 'Se Notes'),
                new FilterColumn($this->dataset, 'samp_obs_name_id', 'LA4', 'Samp Obs Name Id'),
                new FilterColumn($this->dataset, 'samp_observ_numb', 'samp_observ_numb', 'Samp Observ Numb')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['samp_id'])
                ->addColumn($columns['samp_name'])
                ->addColumn($columns['samp_name_dup'])
                ->addColumn($columns['samp_name_blk'])
                ->addColumn($columns['samp_blk_prov'])
                ->addColumn($columns['se_heure'])
                ->addColumn($columns['se_type'])
                ->addColumn($columns['se_prove'])
                ->addColumn($columns['se_meth'])
                ->addColumn($columns['se_purge_vol'])
                ->addColumn($columns['se_purge_duree'])
                ->addColumn($columns['se_purge_debit'])
                ->addColumn($columns['se_purge_meth'])
                ->addColumn($columns['se_notes']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('se_type')
                ->setOptionsFor('se_prove');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('samp_id_edit');
            
            $filterBuilder->addColumn(
                $columns['samp_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('samp_name_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['samp_name'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('samp_name_dup_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['samp_name_dup'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('samp_name_blk_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['samp_name_blk'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('samp_blk_prov_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['samp_blk_prov'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('se_heure_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['se_heure'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('se_type_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('se_type', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search');
            
            $filterBuilder->addColumn(
                $columns['se_type'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('se_prove_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('se_prove', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search');
            
            $filterBuilder->addColumn(
                $columns['se_prove'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('se_meth_edit');
            $main_editor->SetMaxLength(100);
            
            $filterBuilder->addColumn(
                $columns['se_meth'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('se_purge_vol_edit');
            
            $filterBuilder->addColumn(
                $columns['se_purge_vol'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('se_purge_duree_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['se_purge_duree'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('se_purge_debit_edit');
            
            $filterBuilder->addColumn(
                $columns['se_purge_debit'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('se_purge_meth_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['se_purge_meth'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('se_notes');
            
            $filterBuilder->addColumn(
                $columns['se_notes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana detail
            //
            $column = new DetailColumn(array('samp_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_handler', $this->dataset, 'Tbl Samp Eau Ana');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('samp_id', 'samp_id', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Clé primaire identifiant unique pour l\'échantillon d\'eau');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_name', 'samp_name', 'Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('nom unique donné à l\'échantillon');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for samp_name_dup field
            //
            $column = new TextViewColumn('samp_name_dup', 'samp_name_dup', 'Samp Name Dup', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('nom unique donné au premier duplicatat');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for samp_name_blk field
            //
            $column = new TextViewColumn('samp_name_blk', 'samp_name_blk', 'Samp Name Blk', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('nom unique donné au blanc');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for samp_blk_prov field
            //
            $column = new TextViewColumn('samp_blk_prov', 'samp_blk_prov', 'Samp Blk Prov', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for se_heure field
            //
            $column = new TextViewColumn('se_heure', 'se_heure', 'Se Heure', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('heure de la prise d\'échantillon');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_type', 'LA1', 'Se Type', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('provenance de l\'échantillon - catégorie gérale : surface, souterrain, précipitation-pluie, précipitation-neige, blanc, standard, autre');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_prove', 'LA2', 'Se Prove', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('provenance de l\'échantillon - précision (ex: robinet de cuisine, puits, ...)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('méthode de collecte');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for se_purge_vol field
            //
            $column = new NumberViewColumn('se_purge_vol', 'se_purge_vol', 'Se Purge Vol', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('volume d\'eau purgée');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for se_purge_duree field
            //
            $column = new TextViewColumn('se_purge_duree', 'se_purge_duree', 'Se Purge Duree', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('durée de la purge');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for se_purge_debit field
            //
            $column = new NumberViewColumn('se_purge_debit', 'se_purge_debit', 'Se Purge Debit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('débit de la purge');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for se_purge_meth field
            //
            $column = new TextViewColumn('se_purge_meth', 'se_purge_meth', 'Se Purge Meth', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('méthode utilisée pour la purge');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('notes');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('samp_id', 'samp_id', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_name', 'samp_name', 'Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for samp_name_dup field
            //
            $column = new TextViewColumn('samp_name_dup', 'samp_name_dup', 'Samp Name Dup', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for samp_name_blk field
            //
            $column = new TextViewColumn('samp_name_blk', 'samp_name_blk', 'Samp Name Blk', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for samp_blk_prov field
            //
            $column = new TextViewColumn('samp_blk_prov', 'samp_blk_prov', 'Samp Blk Prov', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for se_heure field
            //
            $column = new TextViewColumn('se_heure', 'se_heure', 'Se Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_type', 'LA1', 'Se Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_prove', 'LA2', 'Se Prove', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for se_purge_vol field
            //
            $column = new NumberViewColumn('se_purge_vol', 'se_purge_vol', 'Se Purge Vol', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for se_purge_duree field
            //
            $column = new TextViewColumn('se_purge_duree', 'se_purge_duree', 'Se Purge Duree', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for se_purge_debit field
            //
            $column = new NumberViewColumn('se_purge_debit', 'se_purge_debit', 'Se Purge Debit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for se_purge_meth field
            //
            $column = new TextViewColumn('se_purge_meth', 'se_purge_meth', 'Se Purge Meth', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for samp_name field
            //
            $editor = new TextEdit('samp_name_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name', 'samp_name', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for samp_name_dup field
            //
            $editor = new TextEdit('samp_name_dup_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name Dup', 'samp_name_dup', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for samp_name_blk field
            //
            $editor = new TextEdit('samp_name_blk_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name Blk', 'samp_name_blk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for samp_blk_prov field
            //
            $editor = new TextEdit('samp_blk_prov_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Blk Prov', 'samp_blk_prov', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_heure field
            //
            $editor = new TextEdit('se_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Heure', 'se_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_type field
            //
            $editor = new DynamicCombobox('se_type_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_eau_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_samp_eau_type'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new StringField('groupe'),
                    new IntegerField('lib_samp_eau_type_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Se Type', 'se_type', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search', $editor, $this->dataset, $lookupDataset, 'key_lib_samp_eau_type', 'k_desc_f', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_prove field
            //
            $editor = new DynamicCombobox('se_prove_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_puits_captage"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_puits_captage'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('tempo', true, false, true),
                    new IntegerField('lib_puits_captage_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Se Prove', 'se_prove', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search', $editor, $this->dataset, $lookupDataset, 'key_lib_puits_captage', 'k_desc_f', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_meth field
            //
            $editor = new TextEdit('se_meth_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Se Meth', 'se_meth', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_purge_vol field
            //
            $editor = new TextEdit('se_purge_vol_edit');
            $editColumn = new CustomEditColumn('Se Purge Vol', 'se_purge_vol', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_purge_duree field
            //
            $editor = new TextEdit('se_purge_duree_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Purge Duree', 'se_purge_duree', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_purge_debit field
            //
            $editor = new TextEdit('se_purge_debit_edit');
            $editColumn = new CustomEditColumn('Se Purge Debit', 'se_purge_debit', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_purge_meth field
            //
            $editor = new TextEdit('se_purge_meth_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Purge Meth', 'se_purge_meth', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for se_notes field
            //
            $editor = new TextAreaEdit('se_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Se Notes', 'se_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for samp_name field
            //
            $editor = new TextEdit('samp_name_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name', 'samp_name', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for samp_name_dup field
            //
            $editor = new TextEdit('samp_name_dup_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name Dup', 'samp_name_dup', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for samp_name_blk field
            //
            $editor = new TextEdit('samp_name_blk_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name Blk', 'samp_name_blk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for samp_blk_prov field
            //
            $editor = new TextEdit('samp_blk_prov_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Blk Prov', 'samp_blk_prov', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_heure field
            //
            $editor = new TextEdit('se_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Heure', 'se_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_type field
            //
            $editor = new DynamicCombobox('se_type_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_eau_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_samp_eau_type'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new StringField('groupe'),
                    new IntegerField('lib_samp_eau_type_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Se Type', 'se_type', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search', $editor, $this->dataset, $lookupDataset, 'key_lib_samp_eau_type', 'k_desc_f', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_prove field
            //
            $editor = new DynamicCombobox('se_prove_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_puits_captage"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_puits_captage'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('tempo', true, false, true),
                    new IntegerField('lib_puits_captage_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Se Prove', 'se_prove', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search', $editor, $this->dataset, $lookupDataset, 'key_lib_puits_captage', 'k_desc_f', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_meth field
            //
            $editor = new TextEdit('se_meth_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Se Meth', 'se_meth', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_purge_vol field
            //
            $editor = new TextEdit('se_purge_vol_edit');
            $editColumn = new CustomEditColumn('Se Purge Vol', 'se_purge_vol', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_purge_duree field
            //
            $editor = new TextEdit('se_purge_duree_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Purge Duree', 'se_purge_duree', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_purge_debit field
            //
            $editor = new TextEdit('se_purge_debit_edit');
            $editColumn = new CustomEditColumn('Se Purge Debit', 'se_purge_debit', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_purge_meth field
            //
            $editor = new TextEdit('se_purge_meth_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Purge Meth', 'se_purge_meth', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for se_notes field
            //
            $editor = new TextAreaEdit('se_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Se Notes', 'se_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for samp_name field
            //
            $editor = new TextEdit('samp_name_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name', 'samp_name', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for samp_name_dup field
            //
            $editor = new TextEdit('samp_name_dup_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name Dup', 'samp_name_dup', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for samp_name_blk field
            //
            $editor = new TextEdit('samp_name_blk_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Name Blk', 'samp_name_blk', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for samp_blk_prov field
            //
            $editor = new TextEdit('samp_blk_prov_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Samp Blk Prov', 'samp_blk_prov', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_heure field
            //
            $editor = new TextEdit('se_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Heure', 'se_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_type field
            //
            $editor = new DynamicCombobox('se_type_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_eau_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_samp_eau_type'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new StringField('groupe'),
                    new IntegerField('lib_samp_eau_type_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Se Type', 'se_type', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search', $editor, $this->dataset, $lookupDataset, 'key_lib_samp_eau_type', 'k_desc_f', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_prove field
            //
            $editor = new DynamicCombobox('se_prove_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_puits_captage"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_puits_captage'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('tempo', true, false, true),
                    new IntegerField('lib_puits_captage_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Se Prove', 'se_prove', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search', $editor, $this->dataset, $lookupDataset, 'key_lib_puits_captage', 'k_desc_f', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_meth field
            //
            $editor = new TextEdit('se_meth_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Se Meth', 'se_meth', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_purge_vol field
            //
            $editor = new TextEdit('se_purge_vol_edit');
            $editColumn = new CustomEditColumn('Se Purge Vol', 'se_purge_vol', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_purge_duree field
            //
            $editor = new TextEdit('se_purge_duree_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Purge Duree', 'se_purge_duree', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_purge_debit field
            //
            $editor = new TextEdit('se_purge_debit_edit');
            $editColumn = new CustomEditColumn('Se Purge Debit', 'se_purge_debit', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_purge_meth field
            //
            $editor = new TextEdit('se_purge_meth_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Se Purge Meth', 'se_purge_meth', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for se_notes field
            //
            $editor = new TextAreaEdit('se_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Se Notes', 'se_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('samp_id', 'samp_id', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_name', 'samp_name', 'Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for samp_name_dup field
            //
            $column = new TextViewColumn('samp_name_dup', 'samp_name_dup', 'Samp Name Dup', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for samp_name_blk field
            //
            $column = new TextViewColumn('samp_name_blk', 'samp_name_blk', 'Samp Name Blk', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for samp_blk_prov field
            //
            $column = new TextViewColumn('samp_blk_prov', 'samp_blk_prov', 'Samp Blk Prov', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for se_heure field
            //
            $column = new TextViewColumn('se_heure', 'se_heure', 'Se Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_type', 'LA1', 'Se Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_prove', 'LA2', 'Se Prove', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for se_purge_vol field
            //
            $column = new NumberViewColumn('se_purge_vol', 'se_purge_vol', 'Se Purge Vol', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for se_purge_duree field
            //
            $column = new TextViewColumn('se_purge_duree', 'se_purge_duree', 'Se Purge Duree', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for se_purge_debit field
            //
            $column = new NumberViewColumn('se_purge_debit', 'se_purge_debit', 'Se Purge Debit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for se_purge_meth field
            //
            $column = new TextViewColumn('se_purge_meth', 'se_purge_meth', 'Se Purge Meth', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_print');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for samp_id field
            //
            $column = new NumberViewColumn('samp_id', 'samp_id', 'Samp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_name', 'samp_name', 'Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for samp_name_dup field
            //
            $column = new TextViewColumn('samp_name_dup', 'samp_name_dup', 'Samp Name Dup', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for samp_name_blk field
            //
            $column = new TextViewColumn('samp_name_blk', 'samp_name_blk', 'Samp Name Blk', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for samp_blk_prov field
            //
            $column = new TextViewColumn('samp_blk_prov', 'samp_blk_prov', 'Samp Blk Prov', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for se_heure field
            //
            $column = new TextViewColumn('se_heure', 'se_heure', 'Se Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_type', 'LA1', 'Se Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_prove', 'LA2', 'Se Prove', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for se_purge_vol field
            //
            $column = new NumberViewColumn('se_purge_vol', 'se_purge_vol', 'Se Purge Vol', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for se_purge_duree field
            //
            $column = new TextViewColumn('se_purge_duree', 'se_purge_duree', 'Se Purge Duree', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for se_purge_debit field
            //
            $column = new NumberViewColumn('se_purge_debit', 'se_purge_debit', 'Se Purge Debit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for se_purge_meth field
            //
            $column = new TextViewColumn('se_purge_meth', 'se_purge_meth', 'Se Purge Meth', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_export');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for samp_name field
            //
            $column = new TextViewColumn('samp_name', 'samp_name', 'Samp Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for samp_name_dup field
            //
            $column = new TextViewColumn('samp_name_dup', 'samp_name_dup', 'Samp Name Dup', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for samp_name_blk field
            //
            $column = new TextViewColumn('samp_name_blk', 'samp_name_blk', 'Samp Name Blk', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for samp_blk_prov field
            //
            $column = new TextViewColumn('samp_blk_prov', 'samp_blk_prov', 'Samp Blk Prov', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for se_heure field
            //
            $column = new TextViewColumn('se_heure', 'se_heure', 'Se Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_type', 'LA1', 'Se Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('se_prove', 'LA2', 'Se Prove', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for se_purge_vol field
            //
            $column = new NumberViewColumn('se_purge_vol', 'se_purge_vol', 'Se Purge Vol', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for se_purge_duree field
            //
            $column = new TextViewColumn('se_purge_duree', 'se_purge_duree', 'Se Purge Duree', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for se_purge_debit field
            //
            $column = new NumberViewColumn('se_purge_debit', 'se_purge_debit', 'Se Purge Debit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for se_purge_meth field
            //
            $column = new TextViewColumn('se_purge_meth', 'se_purge_meth', 'Se Purge Meth', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_compare');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function CreateMasterDetailRecordGrid()
        {
            $result = new Grid($this, $this->dataset);
            
            $this->AddFieldColumns($result, false);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            
            $result->SetAllowDeleteSelected(false);
            $result->SetShowUpdateLink(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $this->setupGridColumnGroup($result);
            $this->attachGridEventHandlers($result);
            
            return $result;
        }
        
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $detailPage = new data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_anaPage('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana', $this, array('samp_id'), array('samp_id'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau.data.tbl_samp_eau_ana'));
            $detailPage->SetHttpHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_handler');
            $handler = new PageHTTPHandler('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_data_tbl_samp_eau_ana_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_eau_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_samp_eau_type'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new StringField('groupe'),
                    new IntegerField('lib_samp_eau_type_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search', 'key_lib_samp_eau_type', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_puits_captage"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_puits_captage'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('tempo', true, false, true),
                    new IntegerField('lib_puits_captage_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search', 'key_lib_puits_captage', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_eau_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_samp_eau_type'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new StringField('groupe'),
                    new IntegerField('lib_samp_eau_type_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search', 'key_lib_samp_eau_type', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_puits_captage"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_puits_captage'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('tempo', true, false, true),
                    new IntegerField('lib_puits_captage_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search', 'key_lib_puits_captage', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_meth field
            //
            $column = new TextViewColumn('se_meth', 'se_meth', 'Se Meth', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_meth_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for se_notes field
            //
            $column = new TextViewColumn('se_notes', 'se_notes', 'Se Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_eau_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_samp_eau_type'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new StringField('groupe'),
                    new IntegerField('lib_samp_eau_type_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search', 'key_lib_samp_eau_type', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_puits_captage"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_puits_captage'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('tempo', true, false, true),
                    new IntegerField('lib_puits_captage_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search', 'key_lib_puits_captage', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_samp_eau_type"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_samp_eau_type'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new StringField('groupe'),
                    new IntegerField('lib_samp_eau_type_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_type_search', 'key_lib_samp_eau_type', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_puits_captage"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_puits_captage'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('tempo', true, false, true),
                    new IntegerField('lib_puits_captage_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_se_prove_search', 'key_lib_puits_captage', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_stratPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Log Strat');
            $this->SetMenuLabel('Tbl Log Strat');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_log_strat"');
            $this->dataset->addFields(
                array(
                    new IntegerField('strat_id', true, true, true),
                    new IntegerField('strat_interv'),
                    new StringField('strat_s_interv'),
                    new IntegerField('strat_from'),
                    new IntegerField('strat_to'),
                    new IntegerField('strat_from_em'),
                    new IntegerField('strat_to_em'),
                    new StringField('strat_desc'),
                    new StringField('strat_munsell'),
                    new IntegerField('strat_press'),
                    new StringField('strat_press_un'),
                    new StringField('strat_fiab_lib'),
                    new StringField('strat_meth_lib'),
                    new StringField('notes'),
                    new StringField('code_facies_dominant'),
                    new StringField('code_facies_secondaire'),
                    new StringField('code_facies_tertiaire'),
                    new StringField('code_facies_quatre'),
                    new StringField('code_facies_cinq'),
                    new StringField('code_facies_six'),
                    new IntegerField('strat_obs_name_id', true)
                )
            );
            $this->dataset->AddLookupField('strat_munsell', 'librairies.lib_couleur', new StringField('key_couleur'), new StringField('k_desc_f', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('code_facies_dominant', 'librairies.lib_litho_code_cgq_cgeom', new StringField('key_lib_litho_code_cgq_cgeom'), new StringField('k_desc_f', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('code_facies_secondaire', 'librairies.lib_litho_code_cgq_cgeom', new StringField('key_lib_litho_code_cgq_cgeom'), new StringField('k_desc_f', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('code_facies_tertiaire', 'librairies.lib_litho_code_cgq_cgeom', new StringField('key_lib_litho_code_cgq_cgeom'), new IntegerField('lib_litho_code_cgq_cgeom_id', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('code_facies_quatre', 'librairies.lib_litho_code_cgq_cgeom', new StringField('key_lib_litho_code_cgq_cgeom'), new IntegerField('lib_litho_code_cgq_cgeom_id', false, false, false, false, 'LA5', 'LT5'), 'LT5');
            $this->dataset->AddLookupField('code_facies_cinq', 'librairies.lib_litho_code_cgq_cgeom', new StringField('key_lib_litho_code_cgq_cgeom'), new IntegerField('lib_litho_code_cgq_cgeom_id', false, false, false, false, 'LA6', 'LT6'), 'LT6');
            $this->dataset->AddLookupField('code_facies_six', 'librairies.lib_litho_code_cgq_cgeom', new StringField('key_lib_litho_code_cgq_cgeom'), new IntegerField('lib_litho_code_cgq_cgeom_id', false, false, false, false, 'LA7', 'LT7'), 'LT7');
            $this->dataset->AddLookupField('strat_obs_name_id', '"data".tbl_observation', new IntegerField('observation_id'), new StringField('obs_name', false, false, false, false, 'LA8', 'LT8'), 'LT8');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'strat_id', 'strat_id', 'Strat Id'),
                new FilterColumn($this->dataset, 'strat_interv', 'strat_interv', 'Interval'),
                new FilterColumn($this->dataset, 'strat_s_interv', 'strat_s_interv', 'Strat S Interv'),
                new FilterColumn($this->dataset, 'strat_from', 'strat_from', 'De (m)'),
                new FilterColumn($this->dataset, 'strat_to', 'strat_to', 'A (m)'),
                new FilterColumn($this->dataset, 'strat_from_em', 'strat_from_em', 'Strat From Em'),
                new FilterColumn($this->dataset, 'strat_to_em', 'strat_to_em', 'Strat To Em'),
                new FilterColumn($this->dataset, 'strat_desc', 'strat_desc', 'Description'),
                new FilterColumn($this->dataset, 'strat_munsell', 'LA1', 'Couleur'),
                new FilterColumn($this->dataset, 'strat_press', 'strat_press', 'Strat Press'),
                new FilterColumn($this->dataset, 'strat_press_un', 'strat_press_un', 'Strat Press Un'),
                new FilterColumn($this->dataset, 'strat_fiab_lib', 'strat_fiab_lib', 'Strat Fiab Lib'),
                new FilterColumn($this->dataset, 'strat_meth_lib', 'strat_meth_lib', 'Strat Meth Lib'),
                new FilterColumn($this->dataset, 'notes', 'notes', 'Notes'),
                new FilterColumn($this->dataset, 'code_facies_dominant', 'LA2', 'Facies dominant'),
                new FilterColumn($this->dataset, 'code_facies_secondaire', 'LA3', 'Facies secondaire'),
                new FilterColumn($this->dataset, 'code_facies_tertiaire', 'LA4', 'Code Facies Tertiaire'),
                new FilterColumn($this->dataset, 'code_facies_quatre', 'LA5', 'Code Facies Quatre'),
                new FilterColumn($this->dataset, 'code_facies_cinq', 'LA6', 'Code Facies Cinq'),
                new FilterColumn($this->dataset, 'code_facies_six', 'LA7', 'Code Facies Six'),
                new FilterColumn($this->dataset, 'strat_obs_name_id', 'LA8', 'Strat Obs Name Id')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['strat_id'])
                ->addColumn($columns['strat_interv'])
                ->addColumn($columns['strat_from'])
                ->addColumn($columns['strat_to'])
                ->addColumn($columns['strat_desc'])
                ->addColumn($columns['strat_munsell'])
                ->addColumn($columns['strat_meth_lib'])
                ->addColumn($columns['notes'])
                ->addColumn($columns['code_facies_dominant'])
                ->addColumn($columns['code_facies_secondaire'])
                ->addColumn($columns['strat_obs_name_id']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('strat_munsell')
                ->setOptionsFor('code_facies_dominant')
                ->setOptionsFor('code_facies_secondaire')
                ->setOptionsFor('strat_obs_name_id');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('strat_id_edit');
            
            $filterBuilder->addColumn(
                $columns['strat_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('strat_interv_edit');
            
            $filterBuilder->addColumn(
                $columns['strat_interv'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('strat_from_edit');
            
            $filterBuilder->addColumn(
                $columns['strat_from'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('strat_to_edit');
            
            $filterBuilder->addColumn(
                $columns['strat_to'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('strat_desc');
            
            $filterBuilder->addColumn(
                $columns['strat_desc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('strat_munsell_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('strat_munsell', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search');
            
            $text_editor = new TextEdit('strat_munsell');
            
            $filterBuilder->addColumn(
                $columns['strat_munsell'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('strat_meth_lib_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['strat_meth_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('notes');
            
            $filterBuilder->addColumn(
                $columns['notes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('code_facies_dominant_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('code_facies_dominant', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search');
            
            $filterBuilder->addColumn(
                $columns['code_facies_dominant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('code_facies_secondaire_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('code_facies_secondaire', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search');
            
            $filterBuilder->addColumn(
                $columns['code_facies_secondaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('strat_obs_name_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('strat_obs_name_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search');
            
            $text_editor = new TextEdit('strat_obs_name_id');
            
            $filterBuilder->addColumn(
                $columns['strat_obs_name_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for strat_id field
            //
            $column = new NumberViewColumn('strat_id', 'strat_id', 'Strat Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('identifiant unique');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for strat_interv field
            //
            $column = new NumberViewColumn('strat_interv', 'strat_interv', 'Interval', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('numéro séquentiel de l\'unité stratigraphique');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for strat_from field
            //
            $column = new NumberViewColumn('strat_from', 'strat_from', 'De (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('début de l\'unité stratigraphique (m)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for strat_to field
            //
            $column = new NumberViewColumn('strat_to', 'strat_to', 'A (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('fin de l\'unité stratigraphique (m)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('description litho/stratigraphique');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('strat_munsell', 'LA1', 'Couleur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Munsell color code');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for strat_meth_lib field
            //
            $column = new TextViewColumn('strat_meth_lib', 'strat_meth_lib', 'Strat Meth Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('méthode/source d\'analyse');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_dominant', 'LA2', 'Facies dominant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('code de la librairie des lithofacies CGC-Q et CGEOM');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_secondaire', 'LA3', 'Facies secondaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('code de la librairie des lithofacies CGC-Q et CGEOM');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('strat_obs_name_id', 'LA8', 'Strat Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for strat_id field
            //
            $column = new NumberViewColumn('strat_id', 'strat_id', 'Strat Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for strat_interv field
            //
            $column = new NumberViewColumn('strat_interv', 'strat_interv', 'Interval', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for strat_from field
            //
            $column = new NumberViewColumn('strat_from', 'strat_from', 'De (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for strat_to field
            //
            $column = new NumberViewColumn('strat_to', 'strat_to', 'A (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('strat_munsell', 'LA1', 'Couleur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for strat_meth_lib field
            //
            $column = new TextViewColumn('strat_meth_lib', 'strat_meth_lib', 'Strat Meth Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_dominant', 'LA2', 'Facies dominant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_secondaire', 'LA3', 'Facies secondaire', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('strat_obs_name_id', 'LA8', 'Strat Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for strat_interv field
            //
            $editor = new TextEdit('strat_interv_edit');
            $editColumn = new CustomEditColumn('Interval', 'strat_interv', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for strat_from field
            //
            $editor = new TextEdit('strat_from_edit');
            $editColumn = new CustomEditColumn('De (m)', 'strat_from', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for strat_to field
            //
            $editor = new TextEdit('strat_to_edit');
            $editColumn = new CustomEditColumn('A (m)', 'strat_to', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for strat_desc field
            //
            $editor = new TextAreaEdit('strat_desc_edit', 50, 8);
            $editColumn = new CustomEditColumn('Description', 'strat_desc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for strat_munsell field
            //
            $editor = new DynamicCombobox('strat_munsell_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_couleur"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_couleur', true, true),
                    new StringField('k_desc_f'),
                    new IntegerField('lib_couleur_id', true, false, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Couleur', 'strat_munsell', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search', $editor, $this->dataset, $lookupDataset, 'key_couleur', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for strat_meth_lib field
            //
            $editor = new TextEdit('strat_meth_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Strat Meth Lib', 'strat_meth_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_facies_dominant field
            //
            $editor = new DynamicCombobox('code_facies_dominant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Facies dominant', 'code_facies_dominant', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search', $editor, $this->dataset, $lookupDataset, 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_facies_secondaire field
            //
            $editor = new DynamicCombobox('code_facies_secondaire_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Facies secondaire', 'code_facies_secondaire', 'LA3', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search', $editor, $this->dataset, $lookupDataset, 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for strat_obs_name_id field
            //
            $editor = new DynamicCombobox('strat_obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Strat Obs Name Id', 'strat_obs_name_id', 'LA8', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for strat_interv field
            //
            $editor = new TextEdit('strat_interv_edit');
            $editColumn = new CustomEditColumn('Interval', 'strat_interv', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for strat_from field
            //
            $editor = new TextEdit('strat_from_edit');
            $editColumn = new CustomEditColumn('De (m)', 'strat_from', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for strat_to field
            //
            $editor = new TextEdit('strat_to_edit');
            $editColumn = new CustomEditColumn('A (m)', 'strat_to', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for strat_desc field
            //
            $editor = new TextAreaEdit('strat_desc_edit', 50, 8);
            $editColumn = new CustomEditColumn('Description', 'strat_desc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for strat_munsell field
            //
            $editor = new DynamicCombobox('strat_munsell_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_couleur"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_couleur', true, true),
                    new StringField('k_desc_f'),
                    new IntegerField('lib_couleur_id', true, false, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Couleur', 'strat_munsell', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search', $editor, $this->dataset, $lookupDataset, 'key_couleur', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for strat_meth_lib field
            //
            $editor = new TextEdit('strat_meth_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Strat Meth Lib', 'strat_meth_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_facies_dominant field
            //
            $editor = new DynamicCombobox('code_facies_dominant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Facies dominant', 'code_facies_dominant', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search', $editor, $this->dataset, $lookupDataset, 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_facies_secondaire field
            //
            $editor = new DynamicCombobox('code_facies_secondaire_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Facies secondaire', 'code_facies_secondaire', 'LA3', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search', $editor, $this->dataset, $lookupDataset, 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for strat_obs_name_id field
            //
            $editor = new DynamicCombobox('strat_obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Strat Obs Name Id', 'strat_obs_name_id', 'LA8', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for strat_interv field
            //
            $editor = new TextEdit('strat_interv_edit');
            $editColumn = new CustomEditColumn('Interval', 'strat_interv', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for strat_from field
            //
            $editor = new TextEdit('strat_from_edit');
            $editColumn = new CustomEditColumn('De (m)', 'strat_from', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for strat_to field
            //
            $editor = new TextEdit('strat_to_edit');
            $editColumn = new CustomEditColumn('A (m)', 'strat_to', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for strat_desc field
            //
            $editor = new TextAreaEdit('strat_desc_edit', 50, 8);
            $editColumn = new CustomEditColumn('Description', 'strat_desc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for strat_munsell field
            //
            $editor = new DynamicCombobox('strat_munsell_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_couleur"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_couleur', true, true),
                    new StringField('k_desc_f'),
                    new IntegerField('lib_couleur_id', true, false, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Couleur', 'strat_munsell', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search', $editor, $this->dataset, $lookupDataset, 'key_couleur', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for strat_meth_lib field
            //
            $editor = new TextEdit('strat_meth_lib_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Strat Meth Lib', 'strat_meth_lib', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_facies_dominant field
            //
            $editor = new DynamicCombobox('code_facies_dominant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Facies dominant', 'code_facies_dominant', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search', $editor, $this->dataset, $lookupDataset, 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_facies_secondaire field
            //
            $editor = new DynamicCombobox('code_facies_secondaire_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Facies secondaire', 'code_facies_secondaire', 'LA3', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search', $editor, $this->dataset, $lookupDataset, 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for strat_obs_name_id field
            //
            $editor = new DynamicCombobox('strat_obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Strat Obs Name Id', 'strat_obs_name_id', 'LA8', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for strat_id field
            //
            $column = new NumberViewColumn('strat_id', 'strat_id', 'Strat Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for strat_interv field
            //
            $column = new NumberViewColumn('strat_interv', 'strat_interv', 'Interval', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for strat_from field
            //
            $column = new NumberViewColumn('strat_from', 'strat_from', 'De (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for strat_to field
            //
            $column = new NumberViewColumn('strat_to', 'strat_to', 'A (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('strat_munsell', 'LA1', 'Couleur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for strat_meth_lib field
            //
            $column = new TextViewColumn('strat_meth_lib', 'strat_meth_lib', 'Strat Meth Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_dominant', 'LA2', 'Facies dominant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_secondaire', 'LA3', 'Facies secondaire', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('strat_obs_name_id', 'LA8', 'Strat Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for strat_id field
            //
            $column = new NumberViewColumn('strat_id', 'strat_id', 'Strat Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for strat_interv field
            //
            $column = new NumberViewColumn('strat_interv', 'strat_interv', 'Interval', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for strat_from field
            //
            $column = new NumberViewColumn('strat_from', 'strat_from', 'De (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for strat_to field
            //
            $column = new NumberViewColumn('strat_to', 'strat_to', 'A (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('strat_munsell', 'LA1', 'Couleur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for strat_meth_lib field
            //
            $column = new TextViewColumn('strat_meth_lib', 'strat_meth_lib', 'Strat Meth Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_dominant', 'LA2', 'Facies dominant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_secondaire', 'LA3', 'Facies secondaire', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('strat_obs_name_id', 'LA8', 'Strat Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for strat_interv field
            //
            $column = new NumberViewColumn('strat_interv', 'strat_interv', 'Interval', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for strat_from field
            //
            $column = new NumberViewColumn('strat_from', 'strat_from', 'De (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for strat_to field
            //
            $column = new NumberViewColumn('strat_to', 'strat_to', 'A (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('strat_munsell', 'LA1', 'Couleur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for strat_meth_lib field
            //
            $column = new TextViewColumn('strat_meth_lib', 'strat_meth_lib', 'Strat Meth Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_dominant', 'LA2', 'Facies dominant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('code_facies_secondaire', 'LA3', 'Facies secondaire', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('strat_obs_name_id', 'LA8', 'Strat Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_couleur"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_couleur', true, true),
                    new StringField('k_desc_f'),
                    new IntegerField('lib_couleur_id', true, false, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search', 'key_couleur', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_couleur"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_couleur', true, true),
                    new StringField('k_desc_f'),
                    new IntegerField('lib_couleur_id', true, false, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search', 'key_couleur', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for strat_desc field
            //
            $column = new TextViewColumn('strat_desc', 'strat_desc', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_desc_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_couleur"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_couleur', true, true),
                    new StringField('k_desc_f'),
                    new IntegerField('lib_couleur_id', true, false, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search', 'key_couleur', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_couleur"');
            $lookupDataset->addFields(
                array(
                    new StringField('key_couleur', true, true),
                    new StringField('k_desc_f'),
                    new IntegerField('lib_couleur_id', true, false, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_munsell_search', 'key_couleur', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_dominant_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_litho_code_cgq_cgeom"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('lib_litho_code_cgq_cgeom_id', true, false, true),
                    new StringField('key_lib_litho_code_cgq_cgeom', true, true),
                    new StringField('k_desc_f')
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_code_facies_secondaire_search', 'key_lib_litho_code_cgq_cgeom', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_strat_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompagePage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Pompage');
            $this->SetMenuLabel('Tbl Pompage');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_pompage"');
            $this->dataset->addFields(
                array(
                    new IntegerField('pomp_id', true, true, true),
                    new StringField('type_essai'),
                    new DateTimeField('depart_date', true),
                    new StringField('depart_heure'),
                    new DateTimeField('fin_date'),
                    new StringField('fin_heure'),
                    new IntegerField('debit_essai_pompage'),
                    new StringField('note_debit_essai_pompage'),
                    new StringField('unite_debit_essai_pompage'),
                    new IntegerField('dur_essai_pompage'),
                    new IntegerField('no_essai_pompage'),
                    new IntegerField('temps_repos'),
                    new StringField('info_baro'),
                    new IntegerField('haut_pt_mes'),
                    new StringField('reference_pomp'),
                    new StringField('interpretation'),
                    new IntegerField('prof_dyn_max'),
                    new StringField('num_ref_puit_obs'),
                    new IntegerField('emmagasinement'),
                    new IntegerField('cap_specific'),
                    new IntegerField('transmissivite'),
                    new IntegerField('conduc_hydro'),
                    new StringField('notes'),
                    new IntegerField('obs_name_id'),
                    new IntegerField('nb_puits_obs')
                )
            );
            $this->dataset->AddLookupField('obs_name_id', '"data".tbl_observation', new IntegerField('observation_id'), new StringField('obs_name', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'pomp_id', 'pomp_id', 'Pomp Id'),
                new FilterColumn($this->dataset, 'type_essai', 'type_essai', 'Type Essai'),
                new FilterColumn($this->dataset, 'depart_date', 'depart_date', 'Depart Date'),
                new FilterColumn($this->dataset, 'depart_heure', 'depart_heure', 'Depart Heure'),
                new FilterColumn($this->dataset, 'fin_date', 'fin_date', 'Fin Date'),
                new FilterColumn($this->dataset, 'fin_heure', 'fin_heure', 'Fin Heure'),
                new FilterColumn($this->dataset, 'debit_essai_pompage', 'debit_essai_pompage', 'Debit Essai Pompage'),
                new FilterColumn($this->dataset, 'note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage'),
                new FilterColumn($this->dataset, 'unite_debit_essai_pompage', 'unite_debit_essai_pompage', 'Unite Debit Essai Pompage'),
                new FilterColumn($this->dataset, 'dur_essai_pompage', 'dur_essai_pompage', 'Dur Essai Pompage'),
                new FilterColumn($this->dataset, 'no_essai_pompage', 'no_essai_pompage', 'No Essai Pompage'),
                new FilterColumn($this->dataset, 'temps_repos', 'temps_repos', 'Temps Repos'),
                new FilterColumn($this->dataset, 'info_baro', 'info_baro', 'Info Baro'),
                new FilterColumn($this->dataset, 'haut_pt_mes', 'haut_pt_mes', 'Haut Pt Mes'),
                new FilterColumn($this->dataset, 'reference_pomp', 'reference_pomp', 'Reference Pomp'),
                new FilterColumn($this->dataset, 'interpretation', 'interpretation', 'Interpretation'),
                new FilterColumn($this->dataset, 'prof_dyn_max', 'prof_dyn_max', 'Prof Dyn Max'),
                new FilterColumn($this->dataset, 'num_ref_puit_obs', 'num_ref_puit_obs', 'Num Ref Puit Obs'),
                new FilterColumn($this->dataset, 'emmagasinement', 'emmagasinement', 'Emmagasinement (%)'),
                new FilterColumn($this->dataset, 'cap_specific', 'cap_specific', 'Cap Specific'),
                new FilterColumn($this->dataset, 'transmissivite', 'transmissivite', 'Transmissivite (m2/s)'),
                new FilterColumn($this->dataset, 'conduc_hydro', 'conduc_hydro', 'Conduc Hydro (m/s)'),
                new FilterColumn($this->dataset, 'notes', 'notes', 'Notes'),
                new FilterColumn($this->dataset, 'obs_name_id', 'LA1', 'Obs Name Id'),
                new FilterColumn($this->dataset, 'nb_puits_obs', 'nb_puits_obs', 'Nb Puits Obs')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['pomp_id'])
                ->addColumn($columns['type_essai'])
                ->addColumn($columns['depart_date'])
                ->addColumn($columns['depart_heure'])
                ->addColumn($columns['fin_date'])
                ->addColumn($columns['fin_heure'])
                ->addColumn($columns['debit_essai_pompage'])
                ->addColumn($columns['note_debit_essai_pompage'])
                ->addColumn($columns['unite_debit_essai_pompage'])
                ->addColumn($columns['dur_essai_pompage'])
                ->addColumn($columns['no_essai_pompage'])
                ->addColumn($columns['temps_repos'])
                ->addColumn($columns['info_baro'])
                ->addColumn($columns['haut_pt_mes'])
                ->addColumn($columns['reference_pomp'])
                ->addColumn($columns['interpretation'])
                ->addColumn($columns['prof_dyn_max'])
                ->addColumn($columns['num_ref_puit_obs'])
                ->addColumn($columns['emmagasinement'])
                ->addColumn($columns['cap_specific'])
                ->addColumn($columns['transmissivite'])
                ->addColumn($columns['conduc_hydro'])
                ->addColumn($columns['notes'])
                ->addColumn($columns['obs_name_id'])
                ->addColumn($columns['nb_puits_obs']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('depart_date')
                ->setOptionsFor('fin_date')
                ->setOptionsFor('obs_name_id');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('pomp_id_edit');
            
            $filterBuilder->addColumn(
                $columns['pomp_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('type_essai_edit');
            $main_editor->SetMaxLength(100);
            
            $filterBuilder->addColumn(
                $columns['type_essai'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('depart_date_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['depart_date'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('depart_heure_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['depart_heure'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('fin_date_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['fin_date'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fin_heure_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['fin_heure'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('debit_essai_pompage_edit');
            
            $filterBuilder->addColumn(
                $columns['debit_essai_pompage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('note_debit_essai_pompage');
            
            $filterBuilder->addColumn(
                $columns['note_debit_essai_pompage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('unite_debit_essai_pompage_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['unite_debit_essai_pompage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('dur_essai_pompage_edit');
            
            $filterBuilder->addColumn(
                $columns['dur_essai_pompage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_essai_pompage_edit');
            
            $filterBuilder->addColumn(
                $columns['no_essai_pompage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('temps_repos_edit');
            
            $filterBuilder->addColumn(
                $columns['temps_repos'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('info_baro_edit');
            $main_editor->SetMaxLength(1);
            
            $filterBuilder->addColumn(
                $columns['info_baro'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('haut_pt_mes_edit');
            
            $filterBuilder->addColumn(
                $columns['haut_pt_mes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('reference_pomp_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['reference_pomp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('interpretation_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['interpretation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prof_dyn_max_edit');
            
            $filterBuilder->addColumn(
                $columns['prof_dyn_max'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_ref_puit_obs_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['num_ref_puit_obs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('emmagasinement_edit');
            
            $filterBuilder->addColumn(
                $columns['emmagasinement'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cap_specific_edit');
            
            $filterBuilder->addColumn(
                $columns['cap_specific'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('transmissivite_edit');
            
            $filterBuilder->addColumn(
                $columns['transmissivite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('conduc_hydro_edit');
            
            $filterBuilder->addColumn(
                $columns['conduc_hydro'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('notes');
            
            $filterBuilder->addColumn(
                $columns['notes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_name_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search');
            
            $text_editor = new TextEdit('obs_name_id');
            
            $filterBuilder->addColumn(
                $columns['obs_name_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nb_puits_obs_edit');
            
            $filterBuilder->addColumn(
                $columns['nb_puits_obs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for pomp_id field
            //
            $column = new NumberViewColumn('pomp_id', 'pomp_id', 'Pomp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('(P) Identifiant de la table décrivant les essais de pompage');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Type d\'essai de pompage (LONGUE DURÉE;PAR PALLIER;PERMÉABILITÉ;COURTE DURÉE;REMONTÉE)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for depart_date field
            //
            $column = new DateTimeViewColumn('depart_date', 'depart_date', 'Depart Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Date de départ de l\'essai');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for depart_heure field
            //
            $column = new TextViewColumn('depart_heure', 'depart_heure', 'Depart Heure', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Heure de départ de l\'essai');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for fin_date field
            //
            $column = new DateTimeViewColumn('fin_date', 'fin_date', 'Fin Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Date de fin de l\'essai');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for fin_heure field
            //
            $column = new TextViewColumn('fin_heure', 'fin_heure', 'Fin Heure', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Heure de fin de l\'essai');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for debit_essai_pompage field
            //
            $column = new NumberViewColumn('debit_essai_pompage', 'debit_essai_pompage', 'Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Débit, de  préférence en  m3/sec');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Note sur les unités de débit. DP.');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for unite_debit_essai_pompage field
            //
            $column = new TextViewColumn('unite_debit_essai_pompage', 'unite_debit_essai_pompage', 'Unite Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Unité de mesure du débit de l\'essai de pompage');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for dur_essai_pompage field
            //
            $column = new NumberViewColumn('dur_essai_pompage', 'dur_essai_pompage', 'Dur Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('durée en heures');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for no_essai_pompage field
            //
            $column = new NumberViewColumn('no_essai_pompage', 'no_essai_pompage', 'No Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('No de l\'essai de pompage');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for temps_repos field
            //
            $column = new NumberViewColumn('temps_repos', 'temps_repos', 'Temps Repos', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Temps de repos avant le pompage en heures');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for info_baro field
            //
            $column = new TextViewColumn('info_baro', 'info_baro', 'Info Baro', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Y a-t-il de l\'information barométrique');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for haut_pt_mes field
            //
            $column = new NumberViewColumn('haut_pt_mes', 'haut_pt_mes', 'Haut Pt Mes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Hauteur du point de référence par rapport au sol');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for reference_pomp field
            //
            $column = new TextViewColumn('reference_pomp', 'reference_pomp', 'Reference Pomp', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Références (sol, margelle, autres)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for interpretation field
            //
            $column = new TextViewColumn('interpretation', 'interpretation', 'Interpretation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Le type d\'interprétation');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for prof_dyn_max field
            //
            $column = new NumberViewColumn('prof_dyn_max', 'prof_dyn_max', 'Prof Dyn Max', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Profondeure maximale du niveau dynamique donc la dernière mesure prise');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for num_ref_puit_obs field
            //
            $column = new TextViewColumn('num_ref_puit_obs', 'num_ref_puit_obs', 'Num Ref Puit Obs', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('le numéro de référence du ou des  puits d\'observation');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for emmagasinement field
            //
            $column = new NumberViewColumn('emmagasinement', 'emmagasinement', 'Emmagasinement (%)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Emmagasinement (Vol/Vol) calculé');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for cap_specific field
            //
            $column = new NumberViewColumn('cap_specific', 'cap_specific', 'Cap Specific', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Capacitée spécifique (m2/s) calculée');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for transmissivite field
            //
            $column = new NumberViewColumn('transmissivite', 'transmissivite', 'Transmissivite (m2/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Transmissivitée (m2/s) calculée');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for conduc_hydro field
            //
            $column = new NumberViewColumn('conduc_hydro', 'conduc_hydro', 'Conduc Hydro (m/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Conductivité hydraulique (m/s) calculée');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA1', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé secondaire table observation');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for nb_puits_obs field
            //
            $column = new NumberViewColumn('nb_puits_obs', 'nb_puits_obs', 'Nb Puits Obs', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Nombre de puits d\'observation');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for pomp_id field
            //
            $column = new NumberViewColumn('pomp_id', 'pomp_id', 'Pomp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for depart_date field
            //
            $column = new DateTimeViewColumn('depart_date', 'depart_date', 'Depart Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for depart_heure field
            //
            $column = new TextViewColumn('depart_heure', 'depart_heure', 'Depart Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fin_date field
            //
            $column = new DateTimeViewColumn('fin_date', 'fin_date', 'Fin Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fin_heure field
            //
            $column = new TextViewColumn('fin_heure', 'fin_heure', 'Fin Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for debit_essai_pompage field
            //
            $column = new NumberViewColumn('debit_essai_pompage', 'debit_essai_pompage', 'Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for unite_debit_essai_pompage field
            //
            $column = new TextViewColumn('unite_debit_essai_pompage', 'unite_debit_essai_pompage', 'Unite Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for dur_essai_pompage field
            //
            $column = new NumberViewColumn('dur_essai_pompage', 'dur_essai_pompage', 'Dur Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_essai_pompage field
            //
            $column = new NumberViewColumn('no_essai_pompage', 'no_essai_pompage', 'No Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for temps_repos field
            //
            $column = new NumberViewColumn('temps_repos', 'temps_repos', 'Temps Repos', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for info_baro field
            //
            $column = new TextViewColumn('info_baro', 'info_baro', 'Info Baro', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for haut_pt_mes field
            //
            $column = new NumberViewColumn('haut_pt_mes', 'haut_pt_mes', 'Haut Pt Mes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for reference_pomp field
            //
            $column = new TextViewColumn('reference_pomp', 'reference_pomp', 'Reference Pomp', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for interpretation field
            //
            $column = new TextViewColumn('interpretation', 'interpretation', 'Interpretation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prof_dyn_max field
            //
            $column = new NumberViewColumn('prof_dyn_max', 'prof_dyn_max', 'Prof Dyn Max', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_ref_puit_obs field
            //
            $column = new TextViewColumn('num_ref_puit_obs', 'num_ref_puit_obs', 'Num Ref Puit Obs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for emmagasinement field
            //
            $column = new NumberViewColumn('emmagasinement', 'emmagasinement', 'Emmagasinement (%)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cap_specific field
            //
            $column = new NumberViewColumn('cap_specific', 'cap_specific', 'Cap Specific', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for transmissivite field
            //
            $column = new NumberViewColumn('transmissivite', 'transmissivite', 'Transmissivite (m2/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for conduc_hydro field
            //
            $column = new NumberViewColumn('conduc_hydro', 'conduc_hydro', 'Conduc Hydro (m/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA1', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nb_puits_obs field
            //
            $column = new NumberViewColumn('nb_puits_obs', 'nb_puits_obs', 'Nb Puits Obs', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for type_essai field
            //
            $editor = new TextEdit('type_essai_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Type Essai', 'type_essai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for depart_date field
            //
            $editor = new DateTimeEdit('depart_date_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Depart Date', 'depart_date', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for depart_heure field
            //
            $editor = new TextEdit('depart_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Depart Heure', 'depart_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fin_date field
            //
            $editor = new DateTimeEdit('fin_date_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Fin Date', 'fin_date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fin_heure field
            //
            $editor = new TextEdit('fin_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Fin Heure', 'fin_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for debit_essai_pompage field
            //
            $editor = new TextEdit('debit_essai_pompage_edit');
            $editColumn = new CustomEditColumn('Debit Essai Pompage', 'debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for note_debit_essai_pompage field
            //
            $editor = new TextAreaEdit('note_debit_essai_pompage_edit', 50, 8);
            $editColumn = new CustomEditColumn('Note Debit Essai Pompage', 'note_debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for unite_debit_essai_pompage field
            //
            $editor = new TextEdit('unite_debit_essai_pompage_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Unite Debit Essai Pompage', 'unite_debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for dur_essai_pompage field
            //
            $editor = new TextEdit('dur_essai_pompage_edit');
            $editColumn = new CustomEditColumn('Dur Essai Pompage', 'dur_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_essai_pompage field
            //
            $editor = new TextEdit('no_essai_pompage_edit');
            $editColumn = new CustomEditColumn('No Essai Pompage', 'no_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for temps_repos field
            //
            $editor = new TextEdit('temps_repos_edit');
            $editColumn = new CustomEditColumn('Temps Repos', 'temps_repos', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for info_baro field
            //
            $editor = new TextEdit('info_baro_edit');
            $editor->SetMaxLength(1);
            $editColumn = new CustomEditColumn('Info Baro', 'info_baro', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for haut_pt_mes field
            //
            $editor = new TextEdit('haut_pt_mes_edit');
            $editColumn = new CustomEditColumn('Haut Pt Mes', 'haut_pt_mes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for reference_pomp field
            //
            $editor = new TextEdit('reference_pomp_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Reference Pomp', 'reference_pomp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for interpretation field
            //
            $editor = new TextEdit('interpretation_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Interpretation', 'interpretation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prof_dyn_max field
            //
            $editor = new TextEdit('prof_dyn_max_edit');
            $editColumn = new CustomEditColumn('Prof Dyn Max', 'prof_dyn_max', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_ref_puit_obs field
            //
            $editor = new TextEdit('num_ref_puit_obs_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Num Ref Puit Obs', 'num_ref_puit_obs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for emmagasinement field
            //
            $editor = new TextEdit('emmagasinement_edit');
            $editColumn = new CustomEditColumn('Emmagasinement (%)', 'emmagasinement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cap_specific field
            //
            $editor = new TextEdit('cap_specific_edit');
            $editColumn = new CustomEditColumn('Cap Specific', 'cap_specific', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for transmissivite field
            //
            $editor = new TextEdit('transmissivite_edit');
            $editColumn = new CustomEditColumn('Transmissivite (m2/s)', 'transmissivite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for conduc_hydro field
            //
            $editor = new TextEdit('conduc_hydro_edit');
            $editColumn = new CustomEditColumn('Conduc Hydro (m/s)', 'conduc_hydro', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for obs_name_id field
            //
            $editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Name Id', 'obs_name_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nb_puits_obs field
            //
            $editor = new TextEdit('nb_puits_obs_edit');
            $editColumn = new CustomEditColumn('Nb Puits Obs', 'nb_puits_obs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for type_essai field
            //
            $editor = new TextEdit('type_essai_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Type Essai', 'type_essai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for depart_date field
            //
            $editor = new DateTimeEdit('depart_date_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Depart Date', 'depart_date', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for depart_heure field
            //
            $editor = new TextEdit('depart_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Depart Heure', 'depart_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fin_date field
            //
            $editor = new DateTimeEdit('fin_date_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Fin Date', 'fin_date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fin_heure field
            //
            $editor = new TextEdit('fin_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Fin Heure', 'fin_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for debit_essai_pompage field
            //
            $editor = new TextEdit('debit_essai_pompage_edit');
            $editColumn = new CustomEditColumn('Debit Essai Pompage', 'debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for note_debit_essai_pompage field
            //
            $editor = new TextAreaEdit('note_debit_essai_pompage_edit', 50, 8);
            $editColumn = new CustomEditColumn('Note Debit Essai Pompage', 'note_debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for unite_debit_essai_pompage field
            //
            $editor = new TextEdit('unite_debit_essai_pompage_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Unite Debit Essai Pompage', 'unite_debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for dur_essai_pompage field
            //
            $editor = new TextEdit('dur_essai_pompage_edit');
            $editColumn = new CustomEditColumn('Dur Essai Pompage', 'dur_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_essai_pompage field
            //
            $editor = new TextEdit('no_essai_pompage_edit');
            $editColumn = new CustomEditColumn('No Essai Pompage', 'no_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for temps_repos field
            //
            $editor = new TextEdit('temps_repos_edit');
            $editColumn = new CustomEditColumn('Temps Repos', 'temps_repos', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for info_baro field
            //
            $editor = new TextEdit('info_baro_edit');
            $editor->SetMaxLength(1);
            $editColumn = new CustomEditColumn('Info Baro', 'info_baro', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for haut_pt_mes field
            //
            $editor = new TextEdit('haut_pt_mes_edit');
            $editColumn = new CustomEditColumn('Haut Pt Mes', 'haut_pt_mes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for reference_pomp field
            //
            $editor = new TextEdit('reference_pomp_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Reference Pomp', 'reference_pomp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for interpretation field
            //
            $editor = new TextEdit('interpretation_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Interpretation', 'interpretation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prof_dyn_max field
            //
            $editor = new TextEdit('prof_dyn_max_edit');
            $editColumn = new CustomEditColumn('Prof Dyn Max', 'prof_dyn_max', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_ref_puit_obs field
            //
            $editor = new TextEdit('num_ref_puit_obs_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Num Ref Puit Obs', 'num_ref_puit_obs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for emmagasinement field
            //
            $editor = new TextEdit('emmagasinement_edit');
            $editColumn = new CustomEditColumn('Emmagasinement (%)', 'emmagasinement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cap_specific field
            //
            $editor = new TextEdit('cap_specific_edit');
            $editColumn = new CustomEditColumn('Cap Specific', 'cap_specific', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for transmissivite field
            //
            $editor = new TextEdit('transmissivite_edit');
            $editColumn = new CustomEditColumn('Transmissivite (m2/s)', 'transmissivite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for conduc_hydro field
            //
            $editor = new TextEdit('conduc_hydro_edit');
            $editColumn = new CustomEditColumn('Conduc Hydro (m/s)', 'conduc_hydro', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for obs_name_id field
            //
            $editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Name Id', 'obs_name_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nb_puits_obs field
            //
            $editor = new TextEdit('nb_puits_obs_edit');
            $editColumn = new CustomEditColumn('Nb Puits Obs', 'nb_puits_obs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for type_essai field
            //
            $editor = new TextEdit('type_essai_edit');
            $editor->SetMaxLength(100);
            $editColumn = new CustomEditColumn('Type Essai', 'type_essai', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for depart_date field
            //
            $editor = new DateTimeEdit('depart_date_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Depart Date', 'depart_date', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for depart_heure field
            //
            $editor = new TextEdit('depart_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Depart Heure', 'depart_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fin_date field
            //
            $editor = new DateTimeEdit('fin_date_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Fin Date', 'fin_date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fin_heure field
            //
            $editor = new TextEdit('fin_heure_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Fin Heure', 'fin_heure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for debit_essai_pompage field
            //
            $editor = new TextEdit('debit_essai_pompage_edit');
            $editColumn = new CustomEditColumn('Debit Essai Pompage', 'debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for note_debit_essai_pompage field
            //
            $editor = new TextAreaEdit('note_debit_essai_pompage_edit', 50, 8);
            $editColumn = new CustomEditColumn('Note Debit Essai Pompage', 'note_debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for unite_debit_essai_pompage field
            //
            $editor = new TextEdit('unite_debit_essai_pompage_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Unite Debit Essai Pompage', 'unite_debit_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for dur_essai_pompage field
            //
            $editor = new TextEdit('dur_essai_pompage_edit');
            $editColumn = new CustomEditColumn('Dur Essai Pompage', 'dur_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_essai_pompage field
            //
            $editor = new TextEdit('no_essai_pompage_edit');
            $editColumn = new CustomEditColumn('No Essai Pompage', 'no_essai_pompage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for temps_repos field
            //
            $editor = new TextEdit('temps_repos_edit');
            $editColumn = new CustomEditColumn('Temps Repos', 'temps_repos', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for info_baro field
            //
            $editor = new TextEdit('info_baro_edit');
            $editor->SetMaxLength(1);
            $editColumn = new CustomEditColumn('Info Baro', 'info_baro', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for haut_pt_mes field
            //
            $editor = new TextEdit('haut_pt_mes_edit');
            $editColumn = new CustomEditColumn('Haut Pt Mes', 'haut_pt_mes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for reference_pomp field
            //
            $editor = new TextEdit('reference_pomp_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Reference Pomp', 'reference_pomp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for interpretation field
            //
            $editor = new TextEdit('interpretation_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Interpretation', 'interpretation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prof_dyn_max field
            //
            $editor = new TextEdit('prof_dyn_max_edit');
            $editColumn = new CustomEditColumn('Prof Dyn Max', 'prof_dyn_max', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_ref_puit_obs field
            //
            $editor = new TextEdit('num_ref_puit_obs_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Num Ref Puit Obs', 'num_ref_puit_obs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for emmagasinement field
            //
            $editor = new TextEdit('emmagasinement_edit');
            $editColumn = new CustomEditColumn('Emmagasinement (%)', 'emmagasinement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cap_specific field
            //
            $editor = new TextEdit('cap_specific_edit');
            $editColumn = new CustomEditColumn('Cap Specific', 'cap_specific', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for transmissivite field
            //
            $editor = new TextEdit('transmissivite_edit');
            $editColumn = new CustomEditColumn('Transmissivite (m2/s)', 'transmissivite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for conduc_hydro field
            //
            $editor = new TextEdit('conduc_hydro_edit');
            $editColumn = new CustomEditColumn('Conduc Hydro (m/s)', 'conduc_hydro', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for obs_name_id field
            //
            $editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Name Id', 'obs_name_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nb_puits_obs field
            //
            $editor = new TextEdit('nb_puits_obs_edit');
            $editColumn = new CustomEditColumn('Nb Puits Obs', 'nb_puits_obs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for pomp_id field
            //
            $column = new NumberViewColumn('pomp_id', 'pomp_id', 'Pomp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for depart_date field
            //
            $column = new DateTimeViewColumn('depart_date', 'depart_date', 'Depart Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for depart_heure field
            //
            $column = new TextViewColumn('depart_heure', 'depart_heure', 'Depart Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fin_date field
            //
            $column = new DateTimeViewColumn('fin_date', 'fin_date', 'Fin Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for fin_heure field
            //
            $column = new TextViewColumn('fin_heure', 'fin_heure', 'Fin Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for debit_essai_pompage field
            //
            $column = new NumberViewColumn('debit_essai_pompage', 'debit_essai_pompage', 'Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for unite_debit_essai_pompage field
            //
            $column = new TextViewColumn('unite_debit_essai_pompage', 'unite_debit_essai_pompage', 'Unite Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for dur_essai_pompage field
            //
            $column = new NumberViewColumn('dur_essai_pompage', 'dur_essai_pompage', 'Dur Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_essai_pompage field
            //
            $column = new NumberViewColumn('no_essai_pompage', 'no_essai_pompage', 'No Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for temps_repos field
            //
            $column = new NumberViewColumn('temps_repos', 'temps_repos', 'Temps Repos', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for info_baro field
            //
            $column = new TextViewColumn('info_baro', 'info_baro', 'Info Baro', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for haut_pt_mes field
            //
            $column = new NumberViewColumn('haut_pt_mes', 'haut_pt_mes', 'Haut Pt Mes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for reference_pomp field
            //
            $column = new TextViewColumn('reference_pomp', 'reference_pomp', 'Reference Pomp', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for interpretation field
            //
            $column = new TextViewColumn('interpretation', 'interpretation', 'Interpretation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prof_dyn_max field
            //
            $column = new NumberViewColumn('prof_dyn_max', 'prof_dyn_max', 'Prof Dyn Max', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_ref_puit_obs field
            //
            $column = new TextViewColumn('num_ref_puit_obs', 'num_ref_puit_obs', 'Num Ref Puit Obs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for emmagasinement field
            //
            $column = new NumberViewColumn('emmagasinement', 'emmagasinement', 'Emmagasinement (%)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for cap_specific field
            //
            $column = new NumberViewColumn('cap_specific', 'cap_specific', 'Cap Specific', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for transmissivite field
            //
            $column = new NumberViewColumn('transmissivite', 'transmissivite', 'Transmissivite (m2/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for conduc_hydro field
            //
            $column = new NumberViewColumn('conduc_hydro', 'conduc_hydro', 'Conduc Hydro (m/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA1', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nb_puits_obs field
            //
            $column = new NumberViewColumn('nb_puits_obs', 'nb_puits_obs', 'Nb Puits Obs', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for pomp_id field
            //
            $column = new NumberViewColumn('pomp_id', 'pomp_id', 'Pomp Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for depart_date field
            //
            $column = new DateTimeViewColumn('depart_date', 'depart_date', 'Depart Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for depart_heure field
            //
            $column = new TextViewColumn('depart_heure', 'depart_heure', 'Depart Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fin_date field
            //
            $column = new DateTimeViewColumn('fin_date', 'fin_date', 'Fin Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for fin_heure field
            //
            $column = new TextViewColumn('fin_heure', 'fin_heure', 'Fin Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for debit_essai_pompage field
            //
            $column = new NumberViewColumn('debit_essai_pompage', 'debit_essai_pompage', 'Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for unite_debit_essai_pompage field
            //
            $column = new TextViewColumn('unite_debit_essai_pompage', 'unite_debit_essai_pompage', 'Unite Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for dur_essai_pompage field
            //
            $column = new NumberViewColumn('dur_essai_pompage', 'dur_essai_pompage', 'Dur Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_essai_pompage field
            //
            $column = new NumberViewColumn('no_essai_pompage', 'no_essai_pompage', 'No Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for temps_repos field
            //
            $column = new NumberViewColumn('temps_repos', 'temps_repos', 'Temps Repos', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for info_baro field
            //
            $column = new TextViewColumn('info_baro', 'info_baro', 'Info Baro', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for haut_pt_mes field
            //
            $column = new NumberViewColumn('haut_pt_mes', 'haut_pt_mes', 'Haut Pt Mes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for reference_pomp field
            //
            $column = new TextViewColumn('reference_pomp', 'reference_pomp', 'Reference Pomp', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for interpretation field
            //
            $column = new TextViewColumn('interpretation', 'interpretation', 'Interpretation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prof_dyn_max field
            //
            $column = new NumberViewColumn('prof_dyn_max', 'prof_dyn_max', 'Prof Dyn Max', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for num_ref_puit_obs field
            //
            $column = new TextViewColumn('num_ref_puit_obs', 'num_ref_puit_obs', 'Num Ref Puit Obs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for emmagasinement field
            //
            $column = new NumberViewColumn('emmagasinement', 'emmagasinement', 'Emmagasinement (%)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for cap_specific field
            //
            $column = new NumberViewColumn('cap_specific', 'cap_specific', 'Cap Specific', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for transmissivite field
            //
            $column = new NumberViewColumn('transmissivite', 'transmissivite', 'Transmissivite (m2/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for conduc_hydro field
            //
            $column = new NumberViewColumn('conduc_hydro', 'conduc_hydro', 'Conduc Hydro (m/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA1', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nb_puits_obs field
            //
            $column = new NumberViewColumn('nb_puits_obs', 'nb_puits_obs', 'Nb Puits Obs', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for depart_date field
            //
            $column = new DateTimeViewColumn('depart_date', 'depart_date', 'Depart Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for depart_heure field
            //
            $column = new TextViewColumn('depart_heure', 'depart_heure', 'Depart Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for fin_date field
            //
            $column = new DateTimeViewColumn('fin_date', 'fin_date', 'Fin Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for fin_heure field
            //
            $column = new TextViewColumn('fin_heure', 'fin_heure', 'Fin Heure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for debit_essai_pompage field
            //
            $column = new NumberViewColumn('debit_essai_pompage', 'debit_essai_pompage', 'Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for unite_debit_essai_pompage field
            //
            $column = new TextViewColumn('unite_debit_essai_pompage', 'unite_debit_essai_pompage', 'Unite Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for dur_essai_pompage field
            //
            $column = new NumberViewColumn('dur_essai_pompage', 'dur_essai_pompage', 'Dur Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_essai_pompage field
            //
            $column = new NumberViewColumn('no_essai_pompage', 'no_essai_pompage', 'No Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for temps_repos field
            //
            $column = new NumberViewColumn('temps_repos', 'temps_repos', 'Temps Repos', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for info_baro field
            //
            $column = new TextViewColumn('info_baro', 'info_baro', 'Info Baro', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for haut_pt_mes field
            //
            $column = new NumberViewColumn('haut_pt_mes', 'haut_pt_mes', 'Haut Pt Mes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for reference_pomp field
            //
            $column = new TextViewColumn('reference_pomp', 'reference_pomp', 'Reference Pomp', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for interpretation field
            //
            $column = new TextViewColumn('interpretation', 'interpretation', 'Interpretation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prof_dyn_max field
            //
            $column = new NumberViewColumn('prof_dyn_max', 'prof_dyn_max', 'Prof Dyn Max', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_ref_puit_obs field
            //
            $column = new TextViewColumn('num_ref_puit_obs', 'num_ref_puit_obs', 'Num Ref Puit Obs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for emmagasinement field
            //
            $column = new NumberViewColumn('emmagasinement', 'emmagasinement', 'Emmagasinement (%)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for cap_specific field
            //
            $column = new NumberViewColumn('cap_specific', 'cap_specific', 'Cap Specific', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for transmissivite field
            //
            $column = new NumberViewColumn('transmissivite', 'transmissivite', 'Transmissivite (m2/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for conduc_hydro field
            //
            $column = new NumberViewColumn('conduc_hydro', 'conduc_hydro', 'Conduc Hydro (m/s)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA1', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nb_puits_obs field
            //
            $column = new NumberViewColumn('nb_puits_obs', 'nb_puits_obs', 'Nb Puits Obs', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for type_essai field
            //
            $column = new TextViewColumn('type_essai', 'type_essai', 'Type Essai', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_type_essai_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for note_debit_essai_pompage field
            //
            $column = new TextViewColumn('note_debit_essai_pompage', 'note_debit_essai_pompage', 'Note Debit Essai Pompage', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_note_debit_essai_pompage_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eauPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Niv Eau');
            $this->SetMenuLabel('Tbl Niv Eau');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_niv_eau"');
            $this->dataset->addFields(
                array(
                    new IntegerField('ne_id', true, true, true),
                    new IntegerField('marg_id'),
                    new IntegerField('interv_id'),
                    new StringField('ne_cond1'),
                    new StringField('ne_cond2'),
                    new StringField('ne_cond3'),
                    new StringField('ne_pomp'),
                    new IntegerField('ne_prof'),
                    new IntegerField('ne_prof_em'),
                    new StringField('ne_notes'),
                    new IntegerField('ne_from'),
                    new IntegerField('ne_to'),
                    new IntegerField('obs_name_id'),
                    new IntegerField('ne_posi_niv_lib'),
                    new IntegerField('ne_etat_niv_lib'),
                    new IntegerField('ne_represen_niv_lib')
                )
            );
            $this->dataset->AddLookupField('marg_id', '"data".tbl_margelle', new IntegerField('marg_id'), new StringField('obj_id', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('interv_id', '"data".tbl_puits_interv', new IntegerField('interv_id'), new StringField('obs_name', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('ne_cond1', 'librairies.lib_niv_eau', new StringField('key_lib_niv_eau'), new StringField('k_desc_f', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('ne_cond2', 'librairies.lib_niv_eau', new StringField('key_lib_niv_eau'), new StringField('k_desc_f', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('ne_cond3', 'librairies.lib_niv_eau', new StringField('key_lib_niv_eau'), new StringField('k_desc_f', false, false, false, false, 'LA5', 'LT5'), 'LT5');
            $this->dataset->AddLookupField('obs_name_id', '"data".tbl_observation', new IntegerField('observation_id'), new StringField('obs_name', false, false, false, false, 'LA6', 'LT6'), 'LT6');
            $this->dataset->AddLookupField('ne_posi_niv_lib', 'librairies.lib_niv_eau', new IntegerField('lib_niv_eau_id'), new IntegerField('ordre', false, false, false, false, 'LA7', 'LT7'), 'LT7');
            $this->dataset->AddLookupField('ne_etat_niv_lib', 'librairies.lib_niv_eau', new IntegerField('lib_niv_eau_id'), new IntegerField('ordre', false, false, false, false, 'LA8', 'LT8'), 'LT8');
            $this->dataset->AddLookupField('ne_represen_niv_lib', 'librairies.lib_niv_eau', new IntegerField('lib_niv_eau_id'), new IntegerField('ordre', false, false, false, false, 'LA9', 'LT9'), 'LT9');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'ne_id', 'ne_id', 'Ne Id'),
                new FilterColumn($this->dataset, 'marg_id', 'LA1', 'Marg Id'),
                new FilterColumn($this->dataset, 'interv_id', 'LA2', 'Interv Id'),
                new FilterColumn($this->dataset, 'ne_cond1', 'LA3', 'Ne Cond1'),
                new FilterColumn($this->dataset, 'ne_cond2', 'LA4', 'Ne Cond2'),
                new FilterColumn($this->dataset, 'ne_cond3', 'LA5', 'Ne Cond3'),
                new FilterColumn($this->dataset, 'ne_pomp', 'ne_pomp', 'Pompage (oui/non)'),
                new FilterColumn($this->dataset, 'ne_prof', 'ne_prof', 'Prof niv. eau p/r sol (m)'),
                new FilterColumn($this->dataset, 'ne_prof_em', 'ne_prof_em', 'Ne Prof Em'),
                new FilterColumn($this->dataset, 'ne_notes', 'ne_notes', 'Notes'),
                new FilterColumn($this->dataset, 'ne_from', 'ne_from', 'Ne From'),
                new FilterColumn($this->dataset, 'ne_to', 'ne_to', 'Ne To'),
                new FilterColumn($this->dataset, 'obs_name_id', 'LA6', 'Obs Name Id'),
                new FilterColumn($this->dataset, 'ne_posi_niv_lib', 'LA7', 'Ne Posi Niv Lib'),
                new FilterColumn($this->dataset, 'ne_etat_niv_lib', 'LA8', 'Ne Etat Niv Lib'),
                new FilterColumn($this->dataset, 'ne_represen_niv_lib', 'LA9', 'Ne Represen Niv Lib')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['ne_id'])
                ->addColumn($columns['marg_id'])
                ->addColumn($columns['interv_id'])
                ->addColumn($columns['ne_cond1'])
                ->addColumn($columns['ne_cond2'])
                ->addColumn($columns['ne_cond3'])
                ->addColumn($columns['ne_pomp'])
                ->addColumn($columns['ne_prof'])
                ->addColumn($columns['ne_notes'])
                ->addColumn($columns['obs_name_id']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('marg_id')
                ->setOptionsFor('interv_id')
                ->setOptionsFor('ne_cond1')
                ->setOptionsFor('ne_cond2')
                ->setOptionsFor('ne_cond3')
                ->setOptionsFor('obs_name_id');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('ne_id_edit');
            
            $filterBuilder->addColumn(
                $columns['ne_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('marg_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('marg_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search');
            
            $text_editor = new TextEdit('marg_id');
            
            $filterBuilder->addColumn(
                $columns['marg_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('interv_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('interv_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search');
            
            $text_editor = new TextEdit('interv_id');
            
            $filterBuilder->addColumn(
                $columns['interv_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('ne_cond1_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('ne_cond1', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search');
            
            $text_editor = new TextEdit('ne_cond1');
            
            $filterBuilder->addColumn(
                $columns['ne_cond1'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('ne_cond2_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('ne_cond2', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search');
            
            $text_editor = new TextEdit('ne_cond2');
            
            $filterBuilder->addColumn(
                $columns['ne_cond2'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('ne_cond3_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('ne_cond3', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search');
            
            $text_editor = new TextEdit('ne_cond3');
            
            $filterBuilder->addColumn(
                $columns['ne_cond3'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ne_pomp_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['ne_pomp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ne_prof_edit');
            
            $filterBuilder->addColumn(
                $columns['ne_prof'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ne_notes');
            
            $filterBuilder->addColumn(
                $columns['ne_notes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_name_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search');
            
            $text_editor = new TextEdit('obs_name_id');
            
            $filterBuilder->addColumn(
                $columns['obs_name_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for ne_id field
            //
            $column = new NumberViewColumn('ne_id', 'ne_id', 'Ne Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé unique');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obj_id field
            //
            $column = new TextViewColumn('marg_id', 'LA1', 'Marg Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé secondaire provenant de la table tbl_margelle pour identifier la hauteur de la margelle');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('interv_id', 'LA2', 'Interv Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé secondaire provenant de la table tbl_puits_interv');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond1', 'LA3', 'Ne Cond1', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('position du niveau d\'eau');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond2', 'LA4', 'Ne Cond2', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('état du niveau d\'eau');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond3', 'LA5', 'Ne Cond3', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('représentativité du niveau d\'eau');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ne_pomp field
            //
            $column = new TextViewColumn('ne_pomp', 'ne_pomp', 'Pompage (oui/non)', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('pompage effectué (0;non;1;oui; n/p)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ne_prof field
            //
            $column = new NumberViewColumn('ne_prof', 'ne_prof', 'Prof niv. eau p/r sol (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('profondeur du niveau d\'eau (mesure sonde)');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('notes');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA6', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('clé secondaire table observation');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for ne_id field
            //
            $column = new NumberViewColumn('ne_id', 'ne_id', 'Ne Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obj_id field
            //
            $column = new TextViewColumn('marg_id', 'LA1', 'Marg Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('interv_id', 'LA2', 'Interv Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond1', 'LA3', 'Ne Cond1', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond2', 'LA4', 'Ne Cond2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond3', 'LA5', 'Ne Cond3', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ne_pomp field
            //
            $column = new TextViewColumn('ne_pomp', 'ne_pomp', 'Pompage (oui/non)', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ne_prof field
            //
            $column = new NumberViewColumn('ne_prof', 'ne_prof', 'Prof niv. eau p/r sol (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA6', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for marg_id field
            //
            $editor = new DynamicCombobox('marg_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_margelle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('marg_id', true, true, true),
                    new StringField('obj_id'),
                    new IntegerField('marg_hauteur'),
                    new IntegerField('marg_delta'),
                    new IntegerField('marg_type'),
                    new IntegerField('infra_id'),
                    new StringField('note'),
                    new IntegerField('elevation_marg'),
                    new StringField('reference_elev')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Marg Id', 'marg_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search', $editor, $this->dataset, $lookupDataset, 'marg_id', 'obj_id', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for interv_id field
            //
            $editor = new DynamicCombobox('interv_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_puits_interv"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('interv_id', true, true, true),
                    new StringField('obs_name'),
                    new IntegerField('interv_seq'),
                    new IntegerField('interv_from'),
                    new IntegerField('interv_to'),
                    new IntegerField('interv_from_em'),
                    new IntegerField('interv_to_em'),
                    new StringField('interv_meth_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Interv Id', 'interv_id', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search', $editor, $this->dataset, $lookupDataset, 'interv_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ne_cond1 field
            //
            $editor = new DynamicCombobox('ne_cond1_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 1'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond1', 'ne_cond1', 'LA3', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ne_cond2 field
            //
            $editor = new DynamicCombobox('ne_cond2_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 2'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond2', 'ne_cond2', 'LA4', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ne_cond3 field
            //
            $editor = new DynamicCombobox('ne_cond3_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 3'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond3', 'ne_cond3', 'LA5', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ne_pomp field
            //
            $editor = new TextEdit('ne_pomp_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Pompage (oui/non)', 'ne_pomp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ne_prof field
            //
            $editor = new TextEdit('ne_prof_edit');
            $editColumn = new CustomEditColumn('Prof niv. eau p/r sol (m)', 'ne_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ne_notes field
            //
            $editor = new TextAreaEdit('ne_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'ne_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for obs_name_id field
            //
            $editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Name Id', 'obs_name_id', 'LA6', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for marg_id field
            //
            $editor = new DynamicCombobox('marg_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_margelle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('marg_id', true, true, true),
                    new StringField('obj_id'),
                    new IntegerField('marg_hauteur'),
                    new IntegerField('marg_delta'),
                    new IntegerField('marg_type'),
                    new IntegerField('infra_id'),
                    new StringField('note'),
                    new IntegerField('elevation_marg'),
                    new StringField('reference_elev')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Marg Id', 'marg_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search', $editor, $this->dataset, $lookupDataset, 'marg_id', 'obj_id', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for interv_id field
            //
            $editor = new DynamicCombobox('interv_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_puits_interv"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('interv_id', true, true, true),
                    new StringField('obs_name'),
                    new IntegerField('interv_seq'),
                    new IntegerField('interv_from'),
                    new IntegerField('interv_to'),
                    new IntegerField('interv_from_em'),
                    new IntegerField('interv_to_em'),
                    new StringField('interv_meth_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Interv Id', 'interv_id', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search', $editor, $this->dataset, $lookupDataset, 'interv_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ne_cond1 field
            //
            $editor = new DynamicCombobox('ne_cond1_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 1'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond1', 'ne_cond1', 'LA3', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ne_cond2 field
            //
            $editor = new DynamicCombobox('ne_cond2_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 2'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond2', 'ne_cond2', 'LA4', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ne_cond3 field
            //
            $editor = new DynamicCombobox('ne_cond3_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 3'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond3', 'ne_cond3', 'LA5', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ne_pomp field
            //
            $editor = new TextEdit('ne_pomp_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Pompage (oui/non)', 'ne_pomp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ne_prof field
            //
            $editor = new TextEdit('ne_prof_edit');
            $editColumn = new CustomEditColumn('Prof niv. eau p/r sol (m)', 'ne_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ne_notes field
            //
            $editor = new TextAreaEdit('ne_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'ne_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for obs_name_id field
            //
            $editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Name Id', 'obs_name_id', 'LA6', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for marg_id field
            //
            $editor = new DynamicCombobox('marg_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_margelle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('marg_id', true, true, true),
                    new StringField('obj_id'),
                    new IntegerField('marg_hauteur'),
                    new IntegerField('marg_delta'),
                    new IntegerField('marg_type'),
                    new IntegerField('infra_id'),
                    new StringField('note'),
                    new IntegerField('elevation_marg'),
                    new StringField('reference_elev')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Marg Id', 'marg_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search', $editor, $this->dataset, $lookupDataset, 'marg_id', 'obj_id', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for interv_id field
            //
            $editor = new DynamicCombobox('interv_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_puits_interv"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('interv_id', true, true, true),
                    new StringField('obs_name'),
                    new IntegerField('interv_seq'),
                    new IntegerField('interv_from'),
                    new IntegerField('interv_to'),
                    new IntegerField('interv_from_em'),
                    new IntegerField('interv_to_em'),
                    new StringField('interv_meth_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Interv Id', 'interv_id', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search', $editor, $this->dataset, $lookupDataset, 'interv_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ne_cond1 field
            //
            $editor = new DynamicCombobox('ne_cond1_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 1'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond1', 'ne_cond1', 'LA3', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ne_cond2 field
            //
            $editor = new DynamicCombobox('ne_cond2_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 2'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond2', 'ne_cond2', 'LA4', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ne_cond3 field
            //
            $editor = new DynamicCombobox('ne_cond3_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 3'));
            $editColumn = new DynamicLookupEditColumn('Ne Cond3', 'ne_cond3', 'LA5', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search', $editor, $this->dataset, $lookupDataset, 'key_lib_niv_eau', 'k_desc_f', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ne_pomp field
            //
            $editor = new TextEdit('ne_pomp_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Pompage (oui/non)', 'ne_pomp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ne_prof field
            //
            $editor = new TextEdit('ne_prof_edit');
            $editColumn = new CustomEditColumn('Prof niv. eau p/r sol (m)', 'ne_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ne_notes field
            //
            $editor = new TextAreaEdit('ne_notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'ne_notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for obs_name_id field
            //
            $editor = new DynamicCombobox('obs_name_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Name Id', 'obs_name_id', 'LA6', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for ne_id field
            //
            $column = new NumberViewColumn('ne_id', 'ne_id', 'Ne Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for obj_id field
            //
            $column = new TextViewColumn('marg_id', 'LA1', 'Marg Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('interv_id', 'LA2', 'Interv Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond1', 'LA3', 'Ne Cond1', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond2', 'LA4', 'Ne Cond2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond3', 'LA5', 'Ne Cond3', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ne_pomp field
            //
            $column = new TextViewColumn('ne_pomp', 'ne_pomp', 'Pompage (oui/non)', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ne_prof field
            //
            $column = new NumberViewColumn('ne_prof', 'ne_prof', 'Prof niv. eau p/r sol (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA6', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for ne_id field
            //
            $column = new NumberViewColumn('ne_id', 'ne_id', 'Ne Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for obj_id field
            //
            $column = new TextViewColumn('marg_id', 'LA1', 'Marg Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('interv_id', 'LA2', 'Interv Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond1', 'LA3', 'Ne Cond1', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond2', 'LA4', 'Ne Cond2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond3', 'LA5', 'Ne Cond3', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ne_pomp field
            //
            $column = new TextViewColumn('ne_pomp', 'ne_pomp', 'Pompage (oui/non)', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ne_prof field
            //
            $column = new NumberViewColumn('ne_prof', 'ne_prof', 'Prof niv. eau p/r sol (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA6', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for obj_id field
            //
            $column = new TextViewColumn('marg_id', 'LA1', 'Marg Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('interv_id', 'LA2', 'Interv Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond1', 'LA3', 'Ne Cond1', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond2', 'LA4', 'Ne Cond2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('ne_cond3', 'LA5', 'Ne Cond3', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ne_pomp field
            //
            $column = new TextViewColumn('ne_pomp', 'ne_pomp', 'Pompage (oui/non)', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ne_prof field
            //
            $column = new NumberViewColumn('ne_prof', 'ne_prof', 'Prof niv. eau p/r sol (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name_id', 'LA6', 'Obs Name Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_margelle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('marg_id', true, true, true),
                    new StringField('obj_id'),
                    new IntegerField('marg_hauteur'),
                    new IntegerField('marg_delta'),
                    new IntegerField('marg_type'),
                    new IntegerField('infra_id'),
                    new StringField('note'),
                    new IntegerField('elevation_marg'),
                    new StringField('reference_elev')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search', 'marg_id', 'obj_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_puits_interv"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('interv_id', true, true, true),
                    new StringField('obs_name'),
                    new IntegerField('interv_seq'),
                    new IntegerField('interv_from'),
                    new IntegerField('interv_to'),
                    new IntegerField('interv_from_em'),
                    new IntegerField('interv_to_em'),
                    new StringField('interv_meth_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search', 'interv_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 1'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 2'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 3'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_margelle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('marg_id', true, true, true),
                    new StringField('obj_id'),
                    new IntegerField('marg_hauteur'),
                    new IntegerField('marg_delta'),
                    new IntegerField('marg_type'),
                    new IntegerField('infra_id'),
                    new StringField('note'),
                    new IntegerField('elevation_marg'),
                    new StringField('reference_elev')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search', 'marg_id', 'obj_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_puits_interv"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('interv_id', true, true, true),
                    new StringField('obs_name'),
                    new IntegerField('interv_seq'),
                    new IntegerField('interv_from'),
                    new IntegerField('interv_to'),
                    new IntegerField('interv_from_em'),
                    new IntegerField('interv_to_em'),
                    new StringField('interv_meth_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search', 'interv_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 1'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 2'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 3'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for ne_notes field
            //
            $column = new TextViewColumn('ne_notes', 'ne_notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_margelle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('marg_id', true, true, true),
                    new StringField('obj_id'),
                    new IntegerField('marg_hauteur'),
                    new IntegerField('marg_delta'),
                    new IntegerField('marg_type'),
                    new IntegerField('infra_id'),
                    new StringField('note'),
                    new IntegerField('elevation_marg'),
                    new StringField('reference_elev')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search', 'marg_id', 'obj_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_puits_interv"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('interv_id', true, true, true),
                    new StringField('obs_name'),
                    new IntegerField('interv_seq'),
                    new IntegerField('interv_from'),
                    new IntegerField('interv_to'),
                    new IntegerField('interv_from_em'),
                    new IntegerField('interv_to_em'),
                    new StringField('interv_meth_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search', 'interv_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 1'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 2'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 3'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_margelle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('marg_id', true, true, true),
                    new StringField('obj_id'),
                    new IntegerField('marg_hauteur'),
                    new IntegerField('marg_delta'),
                    new IntegerField('marg_type'),
                    new IntegerField('infra_id'),
                    new StringField('note'),
                    new IntegerField('elevation_marg'),
                    new StringField('reference_elev')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_marg_id_search', 'marg_id', 'obj_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_puits_interv"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('interv_id', true, true, true),
                    new StringField('obs_name'),
                    new IntegerField('interv_seq'),
                    new IntegerField('interv_from'),
                    new IntegerField('interv_to'),
                    new IntegerField('interv_from_em'),
                    new IntegerField('interv_to_em'),
                    new StringField('interv_meth_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_interv_id_search', 'interv_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 1'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond1_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 2'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond2_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_niv_eau"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('ordre'),
                    new StringField('key_lib_niv_eau'),
                    new IntegerField('grp'),
                    new StringField('k_desc_f'),
                    new StringField('k_desc_e'),
                    new IntegerField('lib_niv_eau_id', true, true, true)
                )
            );
            $lookupDataset->setOrderByField('k_desc_f', 'ASC');
            $lookupDataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), 'grp = 3'));
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_ne_cond3_search', 'key_lib_niv_eau', 'k_desc_f', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_obs_name_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_soutPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Serie Temp Eau Sout');
            $this->SetMenuLabel('Serie Temp Eau Sout');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."serie_temp_eau_sout"');
            $this->dataset->addFields(
                array(
                    new IntegerField('eau_sout_id', true, true),
                    new IntegerField('logger_id', true),
                    new DateTimeField('date_time', true),
                    new IntegerField('type_observation', true),
                    new IntegerField('value')
                )
            );
            $this->dataset->AddLookupField('logger_id', '"data".tbl_logger_info', new IntegerField('logger_id'), new IntegerField('obs_id', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('type_observation', 'librairies.lib_type_observation', new IntegerField('obs_type_id'), new StringField('type_observation', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'eau_sout_id', 'eau_sout_id', 'Eau Sout Id'),
                new FilterColumn($this->dataset, 'logger_id', 'LA1', 'Logger Id'),
                new FilterColumn($this->dataset, 'date_time', 'date_time', 'Date Time'),
                new FilterColumn($this->dataset, 'type_observation', 'LA2', 'Type Observation'),
                new FilterColumn($this->dataset, 'value', 'value', 'Unit')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['eau_sout_id'])
                ->addColumn($columns['logger_id'])
                ->addColumn($columns['date_time'])
                ->addColumn($columns['type_observation'])
                ->addColumn($columns['value']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('logger_id')
                ->setOptionsFor('date_time')
                ->setOptionsFor('type_observation');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('eau_sout_id_edit');
            
            $filterBuilder->addColumn(
                $columns['eau_sout_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('logger_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search');
            
            $filterBuilder->addColumn(
                $columns['logger_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_time'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('type_observation', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search');
            
            $filterBuilder->addColumn(
                $columns['type_observation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('value_edit');
            
            $filterBuilder->addColumn(
                $columns['value'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for eau_sout_id field
            //
            $column = new NumberViewColumn('eau_sout_id', 'eau_sout_id', 'Eau Sout Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Unit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for eau_sout_id field
            //
            $column = new NumberViewColumn('eau_sout_id', 'eau_sout_id', 'Eau Sout Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Unit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for eau_sout_id field
            //
            $editor = new TextEdit('eau_sout_id_edit');
            $editColumn = new CustomEditColumn('Eau Sout Id', 'eau_sout_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for logger_id field
            //
            $editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Logger Id', 'logger_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search', $editor, $this->dataset, $lookupDataset, 'logger_id', 'obs_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->setNestedInsertFormLink(
                $this->GetHandlerLink(data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observationNestedPage::getNestedInsertHandlerName())
            );
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Unit', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for logger_id field
            //
            $editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Logger Id', 'logger_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search', $editor, $this->dataset, $lookupDataset, 'logger_id', 'obs_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->setNestedInsertFormLink(
                $this->GetHandlerLink(data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observationNestedPage::getNestedInsertHandlerName())
            );
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Unit', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for eau_sout_id field
            //
            $editor = new TextEdit('eau_sout_id_edit');
            $editColumn = new CustomEditColumn('Eau Sout Id', 'eau_sout_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for logger_id field
            //
            $editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Logger Id', 'logger_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search', $editor, $this->dataset, $lookupDataset, 'logger_id', 'obs_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->setNestedInsertFormLink(
                $this->GetHandlerLink(data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observationNestedPage::getNestedInsertHandlerName())
            );
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Unit', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for eau_sout_id field
            //
            $column = new NumberViewColumn('eau_sout_id', 'eau_sout_id', 'Eau Sout Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Unit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for eau_sout_id field
            //
            $column = new NumberViewColumn('eau_sout_id', 'eau_sout_id', 'Eau Sout Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Unit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for eau_sout_id field
            //
            $column = new NumberViewColumn('eau_sout_id', 'eau_sout_id', 'Eau Sout Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Unit', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surfPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Serie Temp Eau Surf');
            $this->SetMenuLabel('Serie Temp Eau Surf');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."serie_temp_eau_surf"');
            $this->dataset->addFields(
                array(
                    new IntegerField('eau_surf_id', true, true),
                    new IntegerField('logger_id', true),
                    new IntegerField('type_observation', true),
                    new DateTimeField('date_time'),
                    new IntegerField('value')
                )
            );
            $this->dataset->AddLookupField('logger_id', '"data".tbl_logger_info', new IntegerField('logger_id'), new IntegerField('obs_id', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('type_observation', 'librairies.lib_type_observation', new IntegerField('obs_type_id'), new StringField('type_observation', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'eau_surf_id', 'eau_surf_id', 'Eau Surf Id'),
                new FilterColumn($this->dataset, 'logger_id', 'LA1', 'Logger Id'),
                new FilterColumn($this->dataset, 'type_observation', 'LA2', 'Type Observation'),
                new FilterColumn($this->dataset, 'date_time', 'date_time', 'Date Time'),
                new FilterColumn($this->dataset, 'value', 'value', 'Value')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['eau_surf_id'])
                ->addColumn($columns['logger_id'])
                ->addColumn($columns['type_observation'])
                ->addColumn($columns['date_time'])
                ->addColumn($columns['value']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('logger_id')
                ->setOptionsFor('type_observation')
                ->setOptionsFor('date_time');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('eau_surf_id_edit');
            
            $filterBuilder->addColumn(
                $columns['eau_surf_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('logger_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search');
            
            $filterBuilder->addColumn(
                $columns['logger_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('type_observation', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search');
            
            $filterBuilder->addColumn(
                $columns['type_observation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_time'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('value_edit');
            
            $filterBuilder->addColumn(
                $columns['value'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for eau_surf_id field
            //
            $column = new NumberViewColumn('eau_surf_id', 'eau_surf_id', 'Eau Surf Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for eau_surf_id field
            //
            $column = new NumberViewColumn('eau_surf_id', 'eau_surf_id', 'Eau Surf Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for eau_surf_id field
            //
            $editor = new TextEdit('eau_surf_id_edit');
            $editColumn = new CustomEditColumn('Eau Surf Id', 'eau_surf_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for logger_id field
            //
            $editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Logger Id', 'logger_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search', $editor, $this->dataset, $lookupDataset, 'logger_id', 'obs_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->setNestedInsertFormLink(
                $this->GetHandlerLink(data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observationNestedPage::getNestedInsertHandlerName())
            );
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Value', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for logger_id field
            //
            $editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Logger Id', 'logger_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search', $editor, $this->dataset, $lookupDataset, 'logger_id', 'obs_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->setNestedInsertFormLink(
                $this->GetHandlerLink(data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observationNestedPage::getNestedInsertHandlerName())
            );
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Value', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for eau_surf_id field
            //
            $editor = new TextEdit('eau_surf_id_edit');
            $editColumn = new CustomEditColumn('Eau Surf Id', 'eau_surf_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for logger_id field
            //
            $editor = new DynamicCombobox('logger_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Logger Id', 'logger_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search', $editor, $this->dataset, $lookupDataset, 'logger_id', 'obs_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->setNestedInsertFormLink(
                $this->GetHandlerLink(data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observationNestedPage::getNestedInsertHandlerName())
            );
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Value', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for eau_surf_id field
            //
            $column = new NumberViewColumn('eau_surf_id', 'eau_surf_id', 'Eau Surf Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for eau_surf_id field
            //
            $column = new NumberViewColumn('eau_surf_id', 'eau_surf_id', 'Eau Surf Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for eau_surf_id field
            //
            $column = new NumberViewColumn('eau_surf_id', 'eau_surf_id', 'Eau Surf Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for obs_id field
            //
            $column = new NumberViewColumn('logger_id', 'LA1', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA2', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $lookupDataset->setOrderByField('obs_id', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_logger_id_search', 'logger_id', 'obs_id', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_infoPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Logger Info');
            $this->SetMenuLabel('Tbl Logger Info');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_info"');
            $this->dataset->addFields(
                array(
                    new IntegerField('obs_id'),
                    new IntegerField('logger_id', true, true),
                    new IntegerField('prof_sonde'),
                    new StringField('ref_prof_sonde'),
                    new StringField('note'),
                    new DateTimeField('date_instal'),
                    new StringField('serial_number'),
                    new IntegerField('elev_sonde'),
                    new IntegerField('long_cable')
                )
            );
            $this->dataset->AddLookupField('obs_id', '"data".tbl_observation', new IntegerField('observation_id'), new StringField('obs_name', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'obs_id', 'LA1', 'Obs Id'),
                new FilterColumn($this->dataset, 'logger_id', 'logger_id', 'Logger Id'),
                new FilterColumn($this->dataset, 'prof_sonde', 'prof_sonde', 'Prof Sonde (m)'),
                new FilterColumn($this->dataset, 'ref_prof_sonde', 'ref_prof_sonde', 'Ref Prof Sonde'),
                new FilterColumn($this->dataset, 'note', 'note', 'Note'),
                new FilterColumn($this->dataset, 'date_instal', 'date_instal', 'Date Instal'),
                new FilterColumn($this->dataset, 'serial_number', 'serial_number', 'Serial Number'),
                new FilterColumn($this->dataset, 'elev_sonde', 'elev_sonde', 'Altitude sonde (masl)'),
                new FilterColumn($this->dataset, 'long_cable', 'long_cable', '')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['obs_id'])
                ->addColumn($columns['logger_id'])
                ->addColumn($columns['prof_sonde'])
                ->addColumn($columns['ref_prof_sonde'])
                ->addColumn($columns['note'])
                ->addColumn($columns['date_instal'])
                ->addColumn($columns['serial_number'])
                ->addColumn($columns['elev_sonde']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('obs_id')
                ->setOptionsFor('date_instal');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search');
            
            $text_editor = new TextEdit('obs_id');
            
            $filterBuilder->addColumn(
                $columns['obs_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('logger_id_edit');
            
            $filterBuilder->addColumn(
                $columns['logger_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prof_sonde_edit');
            
            $filterBuilder->addColumn(
                $columns['prof_sonde'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ref_prof_sonde_edit');
            
            $filterBuilder->addColumn(
                $columns['ref_prof_sonde'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('note_edit');
            
            $filterBuilder->addColumn(
                $columns['note'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_instal_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_instal'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('serial_number_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['serial_number'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('elev_sonde_edit');
            
            $filterBuilder->addColumn(
                $columns['elev_sonde'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_sout')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout detail
            //
            $column = new DetailColumn(array('logger_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_sout', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_handler', $this->dataset, 'Serie Temp Eau Sout');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_surf')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf detail
            //
            $column = new DetailColumn(array('logger_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_surf', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_handler', $this->dataset, 'Serie Temp Eau Surf');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for logger_id field
            //
            $column = new NumberViewColumn('logger_id', 'logger_id', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for prof_sonde field
            //
            $column = new NumberViewColumn('prof_sonde', 'prof_sonde', 'Prof Sonde (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for ref_prof_sonde field
            //
            $column = new TextViewColumn('ref_prof_sonde', 'ref_prof_sonde', 'Ref Prof Sonde', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for note field
            //
            $column = new TextViewColumn('note', 'note', 'Note', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_instal field
            //
            $column = new DateTimeViewColumn('date_instal', 'date_instal', 'Date Instal', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for elev_sonde field
            //
            $column = new NumberViewColumn('elev_sonde', 'elev_sonde', 'Altitude sonde (masl)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for logger_id field
            //
            $column = new NumberViewColumn('logger_id', 'logger_id', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prof_sonde field
            //
            $column = new NumberViewColumn('prof_sonde', 'prof_sonde', 'Prof Sonde (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ref_prof_sonde field
            //
            $column = new TextViewColumn('ref_prof_sonde', 'ref_prof_sonde', 'Ref Prof Sonde', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for note field
            //
            $column = new TextViewColumn('note', 'note', 'Note', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_instal field
            //
            $column = new DateTimeViewColumn('date_instal', 'date_instal', 'Date Instal', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for elev_sonde field
            //
            $column = new NumberViewColumn('elev_sonde', 'elev_sonde', 'Altitude sonde (masl)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for obs_id field
            //
            $editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Id', 'obs_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for logger_id field
            //
            $editor = new TextEdit('logger_id_edit');
            $editColumn = new CustomEditColumn('Logger Id', 'logger_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prof_sonde field
            //
            $editor = new TextEdit('prof_sonde_edit');
            $editColumn = new CustomEditColumn('Prof Sonde (m)', 'prof_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ref_prof_sonde field
            //
            $editor = new TextEdit('ref_prof_sonde_edit');
            $editColumn = new CustomEditColumn('Ref Prof Sonde', 'ref_prof_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for note field
            //
            $editor = new TextEdit('note_edit');
            $editColumn = new CustomEditColumn('Note', 'note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_instal field
            //
            $editor = new DateTimeEdit('date_instal_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Instal', 'date_instal', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for serial_number field
            //
            $editor = new TextEdit('serial_number_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Serial Number', 'serial_number', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for elev_sonde field
            //
            $editor = new TextEdit('elev_sonde_edit');
            $editColumn = new CustomEditColumn('Altitude sonde (masl)', 'elev_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for obs_id field
            //
            $editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Id', 'obs_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prof_sonde field
            //
            $editor = new TextEdit('prof_sonde_edit');
            $editColumn = new CustomEditColumn('Prof Sonde (m)', 'prof_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ref_prof_sonde field
            //
            $editor = new TextEdit('ref_prof_sonde_edit');
            $editColumn = new CustomEditColumn('Ref Prof Sonde', 'ref_prof_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for note field
            //
            $editor = new TextEdit('note_edit');
            $editColumn = new CustomEditColumn('Note', 'note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_instal field
            //
            $editor = new DateTimeEdit('date_instal_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Instal', 'date_instal', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for serial_number field
            //
            $editor = new TextEdit('serial_number_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Serial Number', 'serial_number', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for elev_sonde field
            //
            $editor = new TextEdit('elev_sonde_edit');
            $editColumn = new CustomEditColumn('Altitude sonde (masl)', 'elev_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for obs_id field
            //
            $editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Id', 'obs_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for logger_id field
            //
            $editor = new TextEdit('logger_id_edit');
            $editColumn = new CustomEditColumn('Logger Id', 'logger_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prof_sonde field
            //
            $editor = new TextEdit('prof_sonde_edit');
            $editColumn = new CustomEditColumn('Prof Sonde (m)', 'prof_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ref_prof_sonde field
            //
            $editor = new TextEdit('ref_prof_sonde_edit');
            $editColumn = new CustomEditColumn('Ref Prof Sonde', 'ref_prof_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for note field
            //
            $editor = new TextEdit('note_edit');
            $editColumn = new CustomEditColumn('Note', 'note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_instal field
            //
            $editor = new DateTimeEdit('date_instal_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Instal', 'date_instal', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for serial_number field
            //
            $editor = new TextEdit('serial_number_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Serial Number', 'serial_number', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for elev_sonde field
            //
            $editor = new TextEdit('elev_sonde_edit');
            $editColumn = new CustomEditColumn('Altitude sonde (masl)', 'elev_sonde', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for logger_id field
            //
            $column = new NumberViewColumn('logger_id', 'logger_id', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for prof_sonde field
            //
            $column = new NumberViewColumn('prof_sonde', 'prof_sonde', 'Prof Sonde (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for ref_prof_sonde field
            //
            $column = new TextViewColumn('ref_prof_sonde', 'ref_prof_sonde', 'Ref Prof Sonde', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for note field
            //
            $column = new TextViewColumn('note', 'note', 'Note', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_instal field
            //
            $column = new DateTimeViewColumn('date_instal', 'date_instal', 'Date Instal', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for elev_sonde field
            //
            $column = new NumberViewColumn('elev_sonde', 'elev_sonde', 'Altitude sonde (masl)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for logger_id field
            //
            $column = new NumberViewColumn('logger_id', 'logger_id', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for prof_sonde field
            //
            $column = new NumberViewColumn('prof_sonde', 'prof_sonde', 'Prof Sonde (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for ref_prof_sonde field
            //
            $column = new TextViewColumn('ref_prof_sonde', 'ref_prof_sonde', 'Ref Prof Sonde', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for note field
            //
            $column = new TextViewColumn('note', 'note', 'Note', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_instal field
            //
            $column = new DateTimeViewColumn('date_instal', 'date_instal', 'Date Instal', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for elev_sonde field
            //
            $column = new NumberViewColumn('elev_sonde', 'elev_sonde', 'Altitude sonde (masl)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for logger_id field
            //
            $column = new NumberViewColumn('logger_id', 'logger_id', 'Logger Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for prof_sonde field
            //
            $column = new NumberViewColumn('prof_sonde', 'prof_sonde', 'Prof Sonde (m)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for ref_prof_sonde field
            //
            $column = new TextViewColumn('ref_prof_sonde', 'ref_prof_sonde', 'Ref Prof Sonde', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for note field
            //
            $column = new TextViewColumn('note', 'note', 'Note', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_instal field
            //
            $column = new DateTimeViewColumn('date_instal', 'date_instal', 'Date Instal', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for elev_sonde field
            //
            $column = new NumberViewColumn('elev_sonde', 'elev_sonde', 'Altitude sonde (masl)', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function CreateMasterDetailRecordGrid()
        {
            $result = new Grid($this, $this->dataset);
            
            $this->AddFieldColumns($result, false);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            
            $result->SetAllowDeleteSelected(false);
            $result->SetShowUpdateLink(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $this->setupGridColumnGroup($result);
            $this->attachGridEventHandlers($result);
            
            return $result;
        }
        
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $detailPage = new data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_soutPage('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout', $this, array('logger_id'), array('logger_id'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_sout'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_sout'));
            $detailPage->SetHttpHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_handler');
            $handler = new PageHTTPHandler('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_sout_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $detailPage = new data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surfPage('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf', $this, array('logger_id'), array('logger_id'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_surf'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info.data.serie_temp_eau_surf'));
            $detailPage->SetHttpHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_handler');
            $handler = new PageHTTPHandler('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_data_serie_temp_eau_surf_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteoPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('View Serie Temp Meteo');
            $this->SetMenuLabel('View Serie Temp Meteo');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"public"."view_serie_temp_meteo"');
            $this->dataset->addFields(
                array(
                    new StringField('loc_alias'),
                    new IntegerField('logger_meteo_id', false, true),
                    new IntegerField('meteo_id', false, true),
                    new DateTimeField('date_time', false, true),
                    new IntegerField('value', false, true),
                    new StringField('type_observation', false, true),
                    new StringField('type_observation_unit', false, true)
                )
            );
            $this->dataset->AddLookupField('type_observation', 'librairies.lib_type_observation', new IntegerField('obs_type_id'), new StringField('type_observation', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('type_observation_unit', 'librairies.lib_type_observation', new IntegerField('obs_type_id'), new StringField('type_observation_unit', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'loc_alias', 'loc_alias', 'Loc Alias'),
                new FilterColumn($this->dataset, 'logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id'),
                new FilterColumn($this->dataset, 'meteo_id', 'meteo_id', 'Meteo Id'),
                new FilterColumn($this->dataset, 'date_time', 'date_time', 'Date Time'),
                new FilterColumn($this->dataset, 'value', 'value', 'Value'),
                new FilterColumn($this->dataset, 'type_observation', 'LA1', 'Type Observation'),
                new FilterColumn($this->dataset, 'type_observation_unit', 'LA2', 'Type Observation Unit')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['loc_alias'])
                ->addColumn($columns['logger_meteo_id'])
                ->addColumn($columns['meteo_id'])
                ->addColumn($columns['date_time'])
                ->addColumn($columns['value'])
                ->addColumn($columns['type_observation'])
                ->addColumn($columns['type_observation_unit']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('date_time')
                ->setOptionsFor('type_observation')
                ->setOptionsFor('type_observation_unit');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('loc_alias');
            
            $filterBuilder->addColumn(
                $columns['loc_alias'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('logger_meteo_id_edit');
            
            $filterBuilder->addColumn(
                $columns['logger_meteo_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('meteo_id_edit');
            
            $filterBuilder->addColumn(
                $columns['meteo_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_time'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('value_edit');
            
            $filterBuilder->addColumn(
                $columns['value'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('type_observation', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search');
            
            $text_editor = new TextEdit('type_observation');
            
            $filterBuilder->addColumn(
                $columns['type_observation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('type_observation_unit_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('type_observation_unit', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search');
            
            $text_editor = new TextEdit('type_observation_unit');
            
            $filterBuilder->addColumn(
                $columns['type_observation_unit'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
    
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for meteo_id field
            //
            $column = new NumberViewColumn('meteo_id', 'meteo_id', 'Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA1', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for type_observation_unit field
            //
            $column = new TextViewColumn('type_observation_unit', 'LA2', 'Type Observation Unit', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for meteo_id field
            //
            $column = new NumberViewColumn('meteo_id', 'meteo_id', 'Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA1', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_observation_unit field
            //
            $column = new TextViewColumn('type_observation_unit', 'LA2', 'Type Observation Unit', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for loc_alias field
            //
            $editor = new TextAreaEdit('loc_alias_edit', 50, 8);
            $editColumn = new CustomEditColumn('Loc Alias', 'loc_alias', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for logger_meteo_id field
            //
            $editor = new TextEdit('logger_meteo_id_edit');
            $editColumn = new CustomEditColumn('Logger Meteo Id', 'logger_meteo_id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for meteo_id field
            //
            $editor = new TextEdit('meteo_id_edit');
            $editColumn = new CustomEditColumn('Meteo Id', 'meteo_id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Value', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_observation_unit field
            //
            $editor = new DynamicCombobox('type_observation_unit_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation Unit', 'type_observation_unit', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation_unit', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for loc_alias field
            //
            $editor = new TextAreaEdit('loc_alias_edit', 50, 8);
            $editColumn = new CustomEditColumn('Loc Alias', 'loc_alias', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for logger_meteo_id field
            //
            $editor = new TextEdit('logger_meteo_id_edit');
            $editColumn = new CustomEditColumn('Logger Meteo Id', 'logger_meteo_id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for meteo_id field
            //
            $editor = new TextEdit('meteo_id_edit');
            $editColumn = new CustomEditColumn('Meteo Id', 'meteo_id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Value', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_observation_unit field
            //
            $editor = new DynamicCombobox('type_observation_unit_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation Unit', 'type_observation_unit', 'LA2', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation_unit', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for loc_alias field
            //
            $editor = new TextAreaEdit('loc_alias_edit', 50, 8);
            $editColumn = new CustomEditColumn('Loc Alias', 'loc_alias', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for logger_meteo_id field
            //
            $editor = new TextEdit('logger_meteo_id_edit');
            $editColumn = new CustomEditColumn('Logger Meteo Id', 'logger_meteo_id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for meteo_id field
            //
            $editor = new TextEdit('meteo_id_edit');
            $editColumn = new CustomEditColumn('Meteo Id', 'meteo_id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_time field
            //
            $editor = new DateTimeEdit('date_time_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date Time', 'date_time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for value field
            //
            $editor = new TextEdit('value_edit');
            $editColumn = new CustomEditColumn('Value', 'value', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_observation field
            //
            $editor = new DynamicCombobox('type_observation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation', 'type_observation', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_observation_unit field
            //
            $editor = new DynamicCombobox('type_observation_unit_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Observation Unit', 'type_observation_unit', 'LA2', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', $editor, $this->dataset, $lookupDataset, 'obs_type_id', 'type_observation_unit', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(false && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_print');
            $grid->AddPrintColumn($column);
            
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for meteo_id field
            //
            $column = new NumberViewColumn('meteo_id', 'meteo_id', 'Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA1', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_observation_unit field
            //
            $column = new TextViewColumn('type_observation_unit', 'LA2', 'Type Observation Unit', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_export');
            $grid->AddExportColumn($column);
            
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for meteo_id field
            //
            $column = new NumberViewColumn('meteo_id', 'meteo_id', 'Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA1', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type_observation_unit field
            //
            $column = new TextViewColumn('type_observation_unit', 'LA2', 'Type Observation Unit', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_compare');
            $grid->AddCompareColumn($column);
            
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for meteo_id field
            //
            $column = new NumberViewColumn('meteo_id', 'meteo_id', 'Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_time field
            //
            $column = new DateTimeViewColumn('date_time', 'date_time', 'Date Time', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for value field
            //
            $column = new NumberViewColumn('value', 'value', 'Value', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_observation field
            //
            $column = new TextViewColumn('type_observation', 'LA1', 'Type Observation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_observation_unit field
            //
            $column = new TextViewColumn('type_observation_unit', 'LA2', 'Type Observation Unit', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(false);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_print', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_compare', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', 'obs_type_id', 'type_observation_unit', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', 'obs_type_id', 'type_observation_unit', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', 'obs_type_id', 'type_observation_unit', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            //
            // View column for loc_alias field
            //
            $column = new TextViewColumn('loc_alias', 'loc_alias', 'Loc Alias', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_loc_alias_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', 'obs_type_id', 'type_observation_unit', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_search', 'obs_type_id', 'type_observation', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"librairies"."lib_type_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('obs_type_id', true, true),
                    new StringField('type_observation', true),
                    new StringField('type_observation_unit', true)
                )
            );
            $lookupDataset->setOrderByField('type_observation_unit', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_type_observation_unit_search', 'obs_type_id', 'type_observation_unit', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteoPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Tbl Logger Meteo');
            $this->SetMenuLabel('Tbl Logger Meteo');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_logger_meteo"');
            $this->dataset->addFields(
                array(
                    new IntegerField('logger_meteo_id', true, true),
                    new IntegerField('obs_id', true),
                    new StringField('logger_type', true),
                    new StringField('serial_number'),
                    new DateField('date_installation', true)
                )
            );
            $this->dataset->AddLookupField('obs_id', '"data".tbl_observation', new IntegerField('observation_id'), new StringField('obs_name', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id'),
                new FilterColumn($this->dataset, 'obs_id', 'LA1', 'Obs Id'),
                new FilterColumn($this->dataset, 'logger_type', 'logger_type', 'Logger Type'),
                new FilterColumn($this->dataset, 'serial_number', 'serial_number', 'Serial Number'),
                new FilterColumn($this->dataset, 'date_installation', 'date_installation', 'Date Installation')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['logger_meteo_id'])
                ->addColumn($columns['obs_id'])
                ->addColumn($columns['logger_type'])
                ->addColumn($columns['serial_number'])
                ->addColumn($columns['date_installation']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('obs_id')
                ->setOptionsFor('date_installation');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('logger_meteo_id_edit');
            
            $filterBuilder->addColumn(
                $columns['logger_meteo_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search');
            
            $text_editor = new TextEdit('obs_id');
            
            $filterBuilder->addColumn(
                $columns['obs_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('logger_type_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['logger_type'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('serial_number_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['serial_number'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_installation_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_installation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_meteo.public.view_serie_temp_meteo')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo detail
            //
            $column = new DetailColumn(array('logger_meteo_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_meteo.public.view_serie_temp_meteo', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_handler', $this->dataset, 'View Serie Temp Meteo');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for logger_type field
            //
            $column = new TextViewColumn('logger_type', 'logger_type', 'Logger Type', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_installation field
            //
            $column = new DateTimeViewColumn('date_installation', 'date_installation', 'Date Installation', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for logger_type field
            //
            $column = new TextViewColumn('logger_type', 'logger_type', 'Logger Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_installation field
            //
            $column = new DateTimeViewColumn('date_installation', 'date_installation', 'Date Installation', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for logger_meteo_id field
            //
            $editor = new TextEdit('logger_meteo_id_edit');
            $editColumn = new CustomEditColumn('Logger Meteo Id', 'logger_meteo_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for obs_id field
            //
            $editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Id', 'obs_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for logger_type field
            //
            $editor = new TextEdit('logger_type_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Logger Type', 'logger_type', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for serial_number field
            //
            $editor = new TextEdit('serial_number_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Serial Number', 'serial_number', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_installation field
            //
            $editor = new DateTimeEdit('date_installation_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Installation', 'date_installation', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for obs_id field
            //
            $editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Id', 'obs_id', 'LA1', 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for logger_type field
            //
            $editor = new TextEdit('logger_type_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Logger Type', 'logger_type', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for serial_number field
            //
            $editor = new TextEdit('serial_number_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Serial Number', 'serial_number', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_installation field
            //
            $editor = new DateTimeEdit('date_installation_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Installation', 'date_installation', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for logger_meteo_id field
            //
            $editor = new TextEdit('logger_meteo_id_edit');
            $editColumn = new CustomEditColumn('Logger Meteo Id', 'logger_meteo_id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for obs_id field
            //
            $editor = new DynamicCombobox('obs_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Id', 'obs_id', 'LA1', 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search', $editor, $this->dataset, $lookupDataset, 'observation_id', 'obs_name', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for logger_type field
            //
            $editor = new TextEdit('logger_type_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Logger Type', 'logger_type', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for serial_number field
            //
            $editor = new TextEdit('serial_number_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Serial Number', 'serial_number', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_installation field
            //
            $editor = new DateTimeEdit('date_installation_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Installation', 'date_installation', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for logger_type field
            //
            $column = new TextViewColumn('logger_type', 'logger_type', 'Logger Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_installation field
            //
            $column = new DateTimeViewColumn('date_installation', 'date_installation', 'Date Installation', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for logger_type field
            //
            $column = new TextViewColumn('logger_type', 'logger_type', 'Logger Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_installation field
            //
            $column = new DateTimeViewColumn('date_installation', 'date_installation', 'Date Installation', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for logger_meteo_id field
            //
            $column = new NumberViewColumn('logger_meteo_id', 'logger_meteo_id', 'Logger Meteo Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_id', 'LA1', 'Obs Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for logger_type field
            //
            $column = new TextViewColumn('logger_type', 'logger_type', 'Logger Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for serial_number field
            //
            $column = new TextViewColumn('serial_number', 'serial_number', 'Serial Number', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_installation field
            //
            $column = new DateTimeViewColumn('date_installation', 'date_installation', 'Date Installation', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function CreateMasterDetailRecordGrid()
        {
            $result = new Grid($this, $this->dataset);
            
            $this->AddFieldColumns($result, false);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            
            $result->SetAllowDeleteSelected(false);
            $result->SetShowUpdateLink(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $this->setupGridColumnGroup($result);
            $this->attachGridEventHandlers($result);
            
            return $result;
        }
        
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
    
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
            $this->AddOperationsColumns($result);
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $detailPage = new data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteoPage('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo', $this, array('logger_meteo_id'), array('logger_meteo_id'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_meteo.public.view_serie_temp_meteo'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_meteo.public.view_serie_temp_meteo'));
            $detailPage->SetHttpHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_handler');
            $handler = new PageHTTPHandler('data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_public_view_serie_temp_meteo_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'insert_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $lookupDataset->setOrderByField('obs_name', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, $this, 'multi_edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_obs_id_search', 'observation_id', 'obs_name', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomPagePermissions(Page $page, PermissionSet &$permissions, &$handled)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class data_tbl_loc_data_tbl_objet_data_tbl_observationPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Observation');
            $this->SetMenuLabel('Observation');
            $this->SetHeader(GetPagesHeader());
            $this->SetFooter(GetPagesFooter());
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_observation"');
            $this->dataset->addFields(
                array(
                    new IntegerField('observation_id', true, false, true),
                    new StringField('obs_name', true, true),
                    new IntegerField('objet_id', true),
                    new IntegerField('obs_lkpart_id', true),
                    new DateField('obs_date', true),
                    new IntegerField('obs_ref_id', true),
                    new DateField('obs_update', true),
                    new StringField('obs_notes'),
                    new StringField('obs_env_lib'),
                    new StringField('obs_precipi_lib'),
                    new StringField('obs_meteo_lib'),
                    new StringField('obs_interet_lib')
                )
            );
            $this->dataset->AddLookupField('objet_id', '"data".tbl_objet', new IntegerField('objet_id'), new StringField('obj_id', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('obs_lkpart_id', '"data".tbl_part', new IntegerField('part_id'), new StringField('f_name', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('obs_ref_id', 'librairies.lib_src_donnees', new StringField('source'), new StringField('k_desc_f', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('obs_env_lib', 'librairies.lib_obs_env', new StringField('key_lib_obs_env'), new StringField('k_desc_f', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('obs_precipi_lib', 'librairies.lib_obs_precipi', new StringField('key_lib_obs_prec'), new StringField('k_desc_f', false, false, false, false, 'LA5', 'LT5'), 'LT5');
            $this->dataset->AddLookupField('obs_meteo_lib', 'librairies.lib_obs_meteo', new StringField('key_lib_obs_meteo'), new StringField('k_desc_f', false, false, false, false, 'LA6', 'LT6'), 'LT6');
            $this->dataset->AddLookupField('obs_interet_lib', 'librairies.lib_obs_interet', new StringField('key_lib_obs_interet'), new StringField('k_desc_f', false, false, false, false, 'LA7', 'LT7'), 'LT7');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(19);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'observation_id', 'observation_id', 'Observation Id'),
                new FilterColumn($this->dataset, 'obs_name', 'obs_name', 'Obs Name'),
                new FilterColumn($this->dataset, 'objet_id', 'LA1', 'Objet Id'),
                new FilterColumn($this->dataset, 'obs_lkpart_id', 'LA2', 'Obs Lkpart Id'),
                new FilterColumn($this->dataset, 'obs_date', 'obs_date', 'Obs Date'),
                new FilterColumn($this->dataset, 'obs_ref_id', 'LA3', 'Obs Ref Id'),
                new FilterColumn($this->dataset, 'obs_update', 'obs_update', 'Obs Update'),
                new FilterColumn($this->dataset, 'obs_notes', 'obs_notes', 'Obs Notes'),
                new FilterColumn($this->dataset, 'obs_env_lib', 'LA4', 'Obs Env Lib'),
                new FilterColumn($this->dataset, 'obs_precipi_lib', 'LA5', 'Obs Precipi Lib'),
                new FilterColumn($this->dataset, 'obs_meteo_lib', 'LA6', 'Obs Meteo Lib'),
                new FilterColumn($this->dataset, 'obs_interet_lib', 'LA7', 'Obs Interet Lib')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['observation_id'])
                ->addColumn($columns['obs_name'])
                ->addColumn($columns['objet_id'])
                ->addColumn($columns['obs_lkpart_id'])
                ->addColumn($columns['obs_date'])
                ->addColumn($columns['obs_ref_id'])
                ->addColumn($columns['obs_update'])
                ->addColumn($columns['obs_notes'])
                ->addColumn($columns['obs_env_lib'])
                ->addColumn($columns['obs_precipi_lib'])
                ->addColumn($columns['obs_meteo_lib'])
                ->addColumn($columns['obs_interet_lib']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('objet_id')
                ->setOptionsFor('obs_lkpart_id')
                ->setOptionsFor('obs_date')
                ->setOptionsFor('obs_ref_id')
                ->setOptionsFor('obs_update')
                ->setOptionsFor('obs_env_lib')
                ->setOptionsFor('obs_precipi_lib')
                ->setOptionsFor('obs_meteo_lib')
                ->setOptionsFor('obs_interet_lib');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('observation_id_edit');
            
            $filterBuilder->addColumn(
                $columns['observation_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('obs_name_edit');
            
            $filterBuilder->addColumn(
                $columns['obs_name'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('objet_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_objet_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('objet_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_objet_id_search');
            
            $text_editor = new TextEdit('objet_id');
            
            $filterBuilder->addColumn(
                $columns['objet_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_lkpart_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_lkpart_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_lkpart_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_lkpart_id_search');
            
            $filterBuilder->addColumn(
                $columns['obs_lkpart_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('obs_date_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['obs_date'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_ref_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_ref_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_ref_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_ref_id_search');
            
            $filterBuilder->addColumn(
                $columns['obs_ref_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('obs_update_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['obs_update'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('obs_notes_edit');
            
            $filterBuilder->addColumn(
                $columns['obs_notes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_env_lib_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_env_lib_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_env_lib', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_env_lib_search');
            
            $filterBuilder->addColumn(
                $columns['obs_env_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_precipi_lib_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_precipi_lib_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_precipi_lib', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_precipi_lib_search');
            
            $text_editor = new TextEdit('obs_precipi_lib');
            
            $filterBuilder->addColumn(
                $columns['obs_precipi_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_meteo_lib_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_meteo_lib_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_meteo_lib', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_meteo_lib_search');
            
            $text_editor = new TextEdit('obs_meteo_lib');
            
            $filterBuilder->addColumn(
                $columns['obs_meteo_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('obs_interet_lib_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_interet_lib_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('obs_interet_lib', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_interet_lib_search');
            
            $filterBuilder->addColumn(
                $columns['obs_interet_lib'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_RIGHT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $operation->SetAdditionalAttribute('data-modal-operation', 'delete');
                $operation->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau detail
            //
            $column = new DetailColumn(array('observation_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_samp_eau', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_samp_eau_handler', $this->dataset, 'Tbl Samp Eau');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_log_strat')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat detail
            //
            $column = new DetailColumn(array('observation_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_log_strat', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_log_strat_handler', $this->dataset, 'Tbl Log Strat');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_pompage')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage detail
            //
            $column = new DetailColumn(array('observation_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_pompage', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_pompage_handler', $this->dataset, 'Tbl Pompage');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_niv_eau')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau detail
            //
            $column = new DetailColumn(array('observation_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_niv_eau', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_niv_eau_handler', $this->dataset, 'Tbl Niv Eau');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info detail
            //
            $column = new DetailColumn(array('observation_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_info', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_info_handler', $this->dataset, 'Tbl Logger Info');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionSetForDataSource('data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_meteo')->HasViewGrant() && $withDetails)
            {
            //
            // View column for data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo detail
            //
            $column = new DetailColumn(array('observation_id'), 'data.tbl_loc.data.tbl_objet.data.tbl_observation.data.tbl_logger_meteo', 'data_tbl_loc_data_tbl_objet_data_tbl_observation_data_tbl_logger_meteo_handler', $this->dataset, 'Tbl Logger Meteo');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for observation_id field
            //
            $column = new NumberViewColumn('observation_id', 'observation_id', 'Observation Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name', 'obs_name', 'Obs Name', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Station name -- Nom de la station [YYPPIIXXXX YY=year; PP=project abbreviation; II=participant initials; XXXX=sequential number]');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obj_id field
            //
            $column = new TextViewColumn('objet_id', 'LA1', 'Objet Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for f_name field
            //
            $column = new TextViewColumn('obs_lkpart_id', 'LA2', 'Obs Lkpart Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Participant provenant de la table lnkPart');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_date field
            //
            $column = new DateTimeViewColumn('obs_date', 'obs_date', 'Obs Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Date of the field stop -- Date de la visite sur le site');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_ref_id', 'LA3', 'Obs Ref Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_update field
            //
            $column = new DateTimeViewColumn('obs_update', 'obs_update', 'Obs Update', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for obs_notes field
            //
            $column = new TextViewColumn('obs_notes', 'obs_notes', 'Obs Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Notes for the station/field stop -- Notes sur la station/visite');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_env_lib', 'LA4', 'Obs Env Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Code de l\'environnment ou l\'observation est effectuée');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_precipi_lib', 'LA5', 'Obs Precipi Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_LA5_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Que tombe t\'il du ciel lorsde l\'observation');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_meteo_lib', 'LA6', 'Obs Meteo Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_LA6_handler_list');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_interet_lib', 'LA7', 'Obs Interet Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $column->SetDescription('Intérêt de l\'observation');
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for observation_id field
            //
            $column = new NumberViewColumn('observation_id', 'observation_id', 'Observation Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_name field
            //
            $column = new TextViewColumn('obs_name', 'obs_name', 'Obs Name', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obj_id field
            //
            $column = new TextViewColumn('objet_id', 'LA1', 'Objet Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for f_name field
            //
            $column = new TextViewColumn('obs_lkpart_id', 'LA2', 'Obs Lkpart Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_date field
            //
            $column = new DateTimeViewColumn('obs_date', 'obs_date', 'Obs Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_ref_id', 'LA3', 'Obs Ref Id', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_update field
            //
            $column = new DateTimeViewColumn('obs_update', 'obs_update', 'Obs Update', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for obs_notes field
            //
            $column = new TextViewColumn('obs_notes', 'obs_notes', 'Obs Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_env_lib', 'LA4', 'Obs Env Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_precipi_lib', 'LA5', 'Obs Precipi Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_LA5_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_meteo_lib', 'LA6', 'Obs Meteo Lib', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('data_tbl_loc_data_tbl_objet_data_tbl_observation_LA6_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for k_desc_f field
            //
            $column = new TextViewColumn('obs_interet_lib', 'LA7', 'Obs Interet Lib', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for obs_name field
            //
            $editor = new TextEdit('obs_name_edit');
            $editColumn = new CustomEditColumn('Obs Name', 'obs_name', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for objet_id field
            //
            $editor = new DynamicCombobox('objet_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_objet"');
            $lookupDataset->addFields(
                array(
                    new StringField('obj_id', true, true),
                    new StringField('loc_id'),
                    new StringField('obj_desc'),
                    new DateField('obj_update'),
                    new IntegerField('objet_id'),
                    new StringField('src_donnees'),
                    new IntegerField('obj_type'),
                    new StringField('nom_original'),
                    new StringField('iden_bd_extern'),
                    new IntegerField('niv_diffusion'),
                    new IntegerField('projet_id')
                )
            );
            $lookupDataset->setOrderByField('obj_id', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Objet Id', 'objet_id', 'LA1', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_objet_id_search', $editor, $this->dataset, $lookupDataset, 'objet_id', 'obj_id', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for obs_lkpart_id field
            //
            $editor = new DynamicCombobox('obs_lkpart_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"data"."tbl_part"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('part_id', true, true, true),
                    new StringField('f_name'),
                    new StringField('m_name'),
                    new StringField('l_name'),
                    new StringField('phone'),
                    new StringField('home_phone'),
                    new StringField('cell'),
                    new StringField('fax'),
                    new StringField('email'),
                    new IntegerField('obs_id'),
                    new StringField('org'),
                    new StringField('projet')
                )
            );
            $lookupDataset->setOrderByField('f_name', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Obs Lkpart Id', 'obs_lkpart_id', 'LA2', 'edit_data_tbl_loc_data_tbl_objet_data_tbl_observation_obs_lkpart_id_search', $editor, $this->dataset, $lookupDataset, 'part_id', 'f_name', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for obs_date field
            //
            $editor = new DateTimeEdit('obs_date_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Obs Date', 'obs_date', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
           